%{!?python_sitelib: %define python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

Name:           python-memcached
Version:        1.53
%define base_release .2
Release:        1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:        A Python memcached client library

Group:          Development/Languages
License:        Python
URL:            http://www.tummy.com/Community/software/python-memcached/
Source0:        https://pypi.python.org/packages/source/p/python-memcached/python-memcached-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch:      noarch
BuildRequires:  python-devel, python-setuptools
# Required for running test suite
BuildRequires:  memcached

%description
This software is a 100% Python interface to the memcached memory cache
daemon.  It is the client side software which allows storing values in one
or more, possibly remote, memcached servers.  Search google for memcached
for more information.

%prep
%setup -q -n %{name}-%{version}

%build
%{__python} setup.py build

%install
rm -rf $RPM_BUILD_ROOT
%{__python} setup.py install -O1 --skip-build --root $RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%check
pushd $RPM_BUILD_ROOT/%{python_sitelib}
pidfile=$(mktemp)
/usr/bin/memcached -d -P $pidfile
%{__python} memcache.py
kill $(cat $pidfile)
popd

%files
%defattr(-,root,root,-)
%doc ChangeLog README.md
%attr(755,root,root) %{python_sitelib}/memcache.py
%{python_sitelib}/memcache.py[co]
%{python_sitelib}/python_memcached-%{version}-py*.egg-info/

%changelog
* Mon Dec 16 2013 baseuser@ibm.com
- Base-8.x spec file
