Summary: A GNU collection of diff utilities
Name: diffutils
Version: 3.3
%define base_release .2
Release: 1%{?dist}%{?base_release}
Group: Applications/Text
URL: http://www.gnu.org/software/diffutils/diffutils.html
Source: ftp://ftp.gnu.org/gnu/diffutils/diffutils-%{version}.tar.xz
Source999: fivextra.tar.bz2
Patch1: diffutils-cmp-s-empty.patch
Patch2: diffutils-mkdir_p.patch
Patch4: diffutils-i18n.patch
License: GPLv3+
Requires(post): info
Requires(preun): info
Provides: bundled(gnulib)
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: help2man

%description
Diffutils includes four utilities: diff, cmp, diff3 and sdiff. Diff
compares two files and shows the differences, line by line.  The cmp
command shows the offset and line numbers where two files differ, or
cmp can show the characters that differ between the two files.  The
diff3 command shows the differences between three files.  Diff3 can be
used when two people have made independent changes to a common
original; diff3 can produce a merged file that contains both sets of
changes and warnings about conflicts.  The sdiff command can be used
to merge two files interactively.

Install diffutils if you need to compare text files.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -a 999
# For 'cmp -s', compare file sizes only if both non-zero (bug #563618).
%patch1 -p1 -b .cmp-s-empty

# Work around @mkdir_p@ build issue.
%patch2 -p1 -b .mkdir_p

%patch4 -p1 -b .i18n

%build
%configure
make PR_PROGRAM=%{_bindir}/pr

pushd fivextra
make all
popd

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

rm -f $RPM_BUILD_ROOT%{_infodir}/dir
%find_lang %{name}

# Steps to package the diffutils tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
make check

%post
/sbin/install-info %{_infodir}/%{name}.info %{_infodir}/dir || :

%preun
if [ $1 = 0 ]; then
  /sbin/install-info --delete %{_infodir}/%{name}.info %{_infodir}/dir || :
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-,root,root)
%doc COPYING NEWS README
%{_bindir}/*
%{_mandir}/*/*
%{_infodir}/diffutils.info*gz

%files fivextra
%{prefix}

%changelog
* Thu May 09 2013 baseuser@ibm.com
- Base-8.x spec file
