# Base disable python3 for now
# if 0%{?fedora}
# global with_python3 1
# {!?py3ver: %global py3ver %(%{__python3} -c "import sys ; print(sys.version[:3])")}
# endif

%{!?py2ver: %global py2ver %(%{__python} -c "import sys ; print sys.version[:3]")}

%global modname webob

Name:           python-webob
Summary:        WSGI request and response object
Version:        1.2.3
%define base_release .2
Release:        4%{?dist}%{?base_release}
License:        MIT
Group:          System Environment/Libraries
URL:            http://pythonpaste.org/webob/
Source0:        http://pypi.python.org/packages/source/W/WebOb/WebOb-%{version}.tar.gz
Source1:        README.Fedora

# https://github.com/Pylons/webob/issues/75
# Fix build/test issue on python 3
Patch1:         webob-1.2.3-test-headers2-fix.patch

BuildArch:      noarch
BuildRequires:  python2-devel
BuildRequires:  python-setuptools
BuildRequires:  python-nose
BuildRequires:  python-dtopt
BuildRequires:  python-tempita
BuildRequires:  python-wsgiproxy
BuildRequires:  python-webtest

%if 0%{?with_python3}
BuildRequires:  python3-devel
BuildRequires:  python3-setuptools
BuildRequires:  python3-nose
%endif

Provides: python-webob1.2 = %{version}-%{release}
Obsoletes: python-webob1.2 < 1.2.3-4

%description
WebOb provides wrappers around the WSGI request environment, and an object to 
help create WSGI responses. The objects map much of the specified behavior of 
HTTP, including header parsing and accessors for other standard parts of the 
environment.

%if 0%{?with_python3}
%package -n python3-webob
Summary:        WSGI request and response object
Group:          System Environment/Libraries

Requires:       python3

%description -n python3-webob
WebOb provides wrappers around the WSGI request environment, and an object to 
help create WSGI responses. The objects map much of the specified behavior of 
HTTP, including header parsing and accessors for other standard parts of the 
environment.
%endif

%prep
%setup -q -n WebOb-%{version}
cp -p %{SOURCE1} .
# Disable performance_test, which requires repoze.profile, which isn't
# in Fedora.
%{__rm} -f tests/performance_test.py

%patch1 -p1 -b .test_headers2

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif

%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif

%install
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root %{buildroot}
#%{__chmod} 0644 %{buildroot}%{python3_sitelib}/WebOb-%{version}-*.egg/%{modname}/*.py
popd
%endif

%{__mkdir} -p %{buildroot}%{python_sitelib}
%{__python} setup.py install --skip-build --root %{buildroot}
#%{__chmod} 0644 %{buildroot}%{python_sitelib}/WebOb-%{version}-*.egg/%{modname}/*.py

%check
%{__python} setup.py test

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py test
popd
%endif

%files
%doc docs/* README.Fedora
%{python_sitelib}/webob/
%{python_sitelib}/WebOb-%{version}-py%{py2ver}.egg-info

%if 0%{?with_python3}
%files -n python3-webob
%doc docs/* README.Fedora
%{python3_sitelib}/webob/
%{python3_sitelib}/WebOb-%{version}-py%{py3ver}.egg-info
%endif

%changelog
* Tue Dec 17 2013 baseuser@ibm.com
- Base-8.x spec file
