%global systemctl_bin /usr/bin/systemctl
%global _hardened_build 1

Summary: The client for the Trivial File Transfer Protocol (TFTP)
Name: tftp
Version: 5.2
%define base_release .2
Release: 9%{?dist}%{?base_release}
License: BSD
Group: Applications/Internet
URL: http://www.kernel.org/pub/software/network/tftp/
Source0: http://www.kernel.org/pub/software/network/tftp/tftp-hpa/tftp-hpa-%{version}.tar.bz2
Source1: tftp.socket
Source2: tftp.service
Source999: fivextra.tar.bz2

Patch0: tftp-0.40-remap.patch
Patch2: tftp-hpa-0.39-tzfix.patch
Patch3: tftp-0.42-tftpboot.patch
Patch4: tftp-0.49-chk_retcodes.patch
Patch5: tftp-hpa-0.49-fortify-strcpy-crash.patch
Patch6: tftp-0.49-cmd_arg.patch
Patch7: tftp-hpa-0.49-stats.patch
Patch8: tftp-hpa-5.2-pktinfo.patch
Patch9: tftp-doc.patch

BuildRequires: tcp_wrappers-devel readline-devel autoconf systemd-units

%description
The Trivial File Transfer Protocol (TFTP) is normally used only for
booting diskless workstations.  The tftp package provides the user
interface for TFTP, which allows users to transfer files to and from a
remote machine.  This program and TFTP provide very little security,
and should not be enabled unless it is expressly needed.

%package server
Group: System Environment/Daemons
Summary: The server for the Trivial File Transfer Protocol (TFTP)
Requires: xinetd systemd-units
Requires(post): /sbin/service, systemd-units
Requires(postun): /sbin/service, systemd-units

%description server
The Trivial File Transfer Protocol (TFTP) is normally used only for
booting diskless workstations.  The tftp-server package provides the
server for TFTP, which allows users to transfer files to and from a
remote machine. TFTP provides very little security, and should not be
enabled unless it is expressly needed.  The TFTP server is run from
%{_sysconfdir}/xinetd.d/tftp, and is disabled by default.

%package fivextra
Summary: FIV Tests for %{name}
Requires: tftp-server
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -n tftp-hpa-%{version} -a 999
%patch0 -p1 -b .zero
%patch2 -p1 -b .tzfix
%patch3 -p1 -b .tftpboot
%patch4 -p1 -b .chk_retcodes
%patch5 -p1 -b .fortify-strcpy-crash
%patch6 -p1 -b .cmd_arg
%patch7 -p1 -b .stats
%patch8 -p1 -b .pktinfo
%patch9 -p1 -b .doc

%build
autoreconf
%configure
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man{1,8}
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}%{_localstatedir}/lib/tftpboot
mkdir -p ${RPM_BUILD_ROOT}%{_unitdir}

make INSTALLROOT=${RPM_BUILD_ROOT} SBINDIR=%{_sbindir} MANDIR=%{_mandir} INSTALL='install -p' install
install -m755 -d -p ${RPM_BUILD_ROOT}%{_sysconfdir}/xinetd.d/ ${RPM_BUILD_ROOT}%{_localstatedir}/lib/tftpboot
sed -e 's:/var:%{_localstatedir}:' -e 's:/usr/sbin:%{_sbindir}:' \
 tftp-xinetd > ${RPM_BUILD_ROOT}%{_sysconfdir}/xinetd.d/tftp
touch -r tftp-xinetd ${RPM_BUILD_ROOT}%{_sysconfdir}/xinetd.d/tftp

install -p -m 644 %SOURCE1 ${RPM_BUILD_ROOT}%{_unitdir}
install -p -m 644 %SOURCE2 ${RPM_BUILD_ROOT}%{_unitdir}

# Steps to package the tftp tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
       install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
       install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done 
find $RPM_BUILD_ROOT/%{fivdir}/%{name} -depth -name CVS -type d -exec rm -rf {} \;
     
install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post server
%systemd_post tftp.service

%preun server
%systemd_preun tftp.service

%postun server
%systemd_postun_with_restart tftp.service


%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%doc README README.security CHANGES
%{_bindir}/tftp
%{_mandir}/man1/*

%files server
%doc README README.security CHANGES
%config(noreplace) %{_sysconfdir}/xinetd.d/tftp
%dir %{_localstatedir}/lib/tftpboot
%{_sbindir}/in.tftpd
%{_mandir}/man8/*
%{_unitdir}/*

%files fivextra
%{prefix}

%changelog
* Tue Jul 16 2013 baseuser@ibm.com
- Base-8.x spec file
