Name: libcap
Version: 2.22
%define base_release .3
Release: 6%{?dist}%{?base_release}
Summary: Library for getting and setting POSIX.1e capabilities
# Original tarball should be here, but got deleted:
#Source: http://www.kernel.org/pub/linux/libs/security/linux-privs/kernel-2.6/libcap-2.22.tar.bz2
Source: http://mirror.linux.org.au/linux/libs/security/linux-privs/libcap2/%{name}-%{version}.tar.bz2
# http://manned.org/getpcaps/299a4949/src:
Source1: getpcaps.8
Source999: fivextra.tar.bz2
Patch0: %{name}-2.22-buildflags.patch
Patch1: libcap-2.22-signed-sizeof-compare.patch
Patch2: bug-96406-quicktest_accepted_failures.patch

URL: http://ftp.kernel.org/pub/linux/libs/security/linux-privs/kernel-2.6/
License: LGPLv2+
Group: System Environment/Libraries
BuildRequires: libattr-devel pam-devel

%description
libcap is a library for getting and setting POSIX.1e (formerly POSIX 6)
draft 15 capabilities.

%package devel
Summary: Development files for libcap
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}

%description devel
Development files (Headers, libraries for static linking, etc) for libcap.

libcap is a library for getting and setting POSIX.1e (formerly POSIX 6)
draft 15 capabilities.

Install libcap-devel if you want to develop or compile applications using
libcap.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999
%patch0 -p1
%patch1 -p1
%patch2 -p1

%build
# libcap can not be build with _smp_mflags:
make BUILD_CC=gcc CC=%{__cc} PREFIX=%{_prefix} LIBDIR=%{_lib} SBINDIR=%{_sbindir} \
      INCDIR=%{_includedir} MANDIR=%{_mandir} COPTFLAG="$RPM_OPT_FLAGS"

%install
make install RAISE_SETFCAP=no \
             DESTDIR=%{buildroot} \
             LIBDIR=%{buildroot}/%{_libdir} \
             SBINDIR=%{buildroot}/%{_sbindir} \
             INCDIR=%{buildroot}/%{_includedir} \
             MANDIR=%{buildroot}/%{_mandir}/
mkdir -p %{buildroot}/%{_mandir}/man{2,3,8}
mv -f doc/*.3 %{buildroot}/%{_mandir}/man3/
cp -f %{SOURCE1} %{buildroot}/%{_mandir}/man8/

# remove static lib
rm -f %{buildroot}/%{_libdir}/libcap.a

chmod +x %{buildroot}/%{_libdir}/*.so.*

# Steps to package the libcap tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done
install progs/quicktest.sh $RPM_BUILD_ROOT/%{fivdir}/%{name}

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
/%{_libdir}/*.so.*
%{_sbindir}/*
%{_mandir}/man1/*
%{_mandir}/man8/*
/%{_libdir}/security/pam_cap.so
%doc doc/capability.notes License

%files devel
%defattr(-,root,root,-)
%{_includedir}/*
/%{_libdir}/*.so
%{_mandir}/man3/*

%files fivextra
%{prefix}

%clean
rm -rf %{buildroot}

%changelog
* Fri Jul 05 2013 baseuser@ibm.com
- Base-8.x spec file
