%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%{!?python_version: %global python_version %(%{__python} -c "from distutils.sysconfig import get_python_version; print get_python_version()")}

Name:           python-qpid
Version:        0.24
%define base_release .2
Release:        1%{?dist}%{?base_release}
Summary:        Python client library for AMQP

License:        ASL 2.0
URL:            http://qpid.apache.org
Source0:        http://www.apache.org/dyn/closer.cgi/qpid/%{version}/qpid-python-%{version}.tar.gz

BuildArch:      noarch

BuildRequires:  python-devel

Requires:       python-qpid-common = %{version}-%{release}

%description
The Apache Qpid Python client library for AMQP.



%package -n python-qpid-common
Summary:   Shared code for Qpid Python language bindings


%description -n python-qpid-common
%{summary}.


%files -n python-qpid-common
%doc LICENSE.txt
%doc examples
%{python_sitelib}/mllib
%{python_sitelib}/qpid/*.py*
%{python_sitelib}/qpid/specs


%prep
%setup -q -n qpid-%{version}/python
cd ..

%build
CFLAGS="$RPM_OPT_FLAGS" %{__python} setup.py build

%install
rm -rf $RPM_BUILD_ROOT
%{__python} setup.py install --skip-build --root $RPM_BUILD_ROOT

chmod +x %{buildroot}/%{python_sitelib}/qpid/codec.py
chmod +x %{buildroot}/%{python_sitelib}/qpid/tests/codec.py
chmod +x %{buildroot}/%{python_sitelib}/qpid/reference.py
chmod +x %{buildroot}/%{python_sitelib}/qpid/managementdata.py
chmod +x %{buildroot}/%{python_sitelib}/qpid/disp.py

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc LICENSE.txt NOTICE.txt README.txt
%{_bindir}/qpid-python-test
%{python_sitelib}/qpid

%exclude %{python_sitelib}/qpid/tests

%if "%{python_version}" >= "2.6"
%{python_sitelib}/qpid_python-*.egg-info
%endif

%changelog
* Mon Dec 16 2013 baseuser@ibm.com
- Base-8.x spec file
