Summary: A GNU archiving program
Name: cpio
Version: 2.11
%define base_release .3
Release: 20%{?dist}%{?base_release}
License: GPLv3+
Group: Applications/Archiving
URL: http://www.gnu.org/software/cpio/
Source: ftp://ftp.gnu.org/gnu/cpio/cpio-%{version}.tar.bz2
# help2man generated manual page distributed only in RHEL/Fedora
Source1: cpio.1
Source999: fivextra.tar.bz2
Source66325: GFDL.txt
#We use SVR4 portable format as default .
Patch1: cpio-2.9-rh.patch
#fix warn_if_file_changed() and set exit code to 1 when cpio
# fails to store file > 4GB (#183224)
Patch2: cpio-2.9-exitCode.patch
#Support major/minor device numbers over 127 (bz#450109)
Patch3: cpio-2.9-dev_number.patch
#define default remote shell as /usr/bin/ssh(#452904)
Patch4: cpio-2.9.90-defaultremoteshell.patch
#fix segfault with nonexisting file with patternnames(#567022)
Patch5: cpio-2.10-patternnamesigsegv.patch
#fix rawhide buildfailure by updating gnulib's stdio.in.h
Patch6: cpio-2.11-stdio.in.patch
# fix bad file name splitting while creating ustar archive (#866467)
Patch7: cpio-2.10-longnames-split.patch
# cpio does Sum32 checksum, not CRC
Patch8: cpio-2.11-crc-fips-nit.patch
# use the config.guess/config.sub files from actual automake-1.13
# ~> #925189
Patch9: cpio-2.11-arm-config-sub-guess.patch
# http://git.savannah.gnu.org/cgit/cpio.git/commit/src/filetypes.h?id=3a7a1820d4cecbd77c7b74c785af5942510bf080
Patch92287: bug-92287-remove_stat_lstat_declarations.patch

Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
Provides: bundled(gnulib)
Provides: /bin/cpio
BuildRequires: texinfo, autoconf, automake, gettext, rmt
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
GNU cpio copies files into or out of a cpio or tar archive.  Archives
are files which contain a collection of other files plus information
about them, such as their file name, owner, timestamps, and access
permissions.  The archive can be another file on the disk, a magnetic
tape, or a pipe.  GNU cpio supports the following archive formats:  binary,
old ASCII, new ASCII, crc, HPUX binary, HPUX old ASCII, old tar and POSIX.1
tar.  By default, cpio creates binary format archives, so that they are
compatible with older cpio programs.  When it is extracting files from
archives, cpio automatically recognizes which kind of archive it is reading
and can read archives created on machines with a different byte-order.

Install cpio if you need a program to manage file archives.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -a 999
cp %{SOURCE66325} doc/.
%patch1 -p1 -b .rh
%patch2 -p1 -b .exitCode
%patch3 -p1 -b .dev_number
%patch4 -p1 -b .defaultremote
%patch5 -p1 -b .patternsegv
%patch6 -p1 -b .gnulib %{?_rawbuild}
%patch7 -p1 -b .longnames
%patch8 -p1 -b .sum32-fips
%patch9 -p1 -b .arm-config-guess-sub
%patch92287 -p1

autoreconf -v

%build

CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE -D_FILE_OFFSET_BITS=64 -D_LARGEFILE64_SOURCE -pedantic -fno-strict-aliasing -Wall" %configure --with-rmt="%{_sysconfdir}/rmt"
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
rm -rf ${RPM_BUILD_ROOT}

make DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p" install


rm -f $RPM_BUILD_ROOT%{_libexecdir}/rmt
rm -f $RPM_BUILD_ROOT%{_infodir}/dir
rm -f $RPM_BUILD_ROOT%{_mandir}/man1/*.1*
install -c -p -m 0644 %{SOURCE1} ${RPM_BUILD_ROOT}%{_mandir}/man1

# Steps to package the acpid tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%find_lang %{name}

%clean
rm -rf ${RPM_BUILD_ROOT}

%check
rm -f ${RPM_BUILD_ROOT}/test/testsuite
make check


%post
if [ -f %{_infodir}/cpio.info.gz ]; then
	/sbin/install-info %{_infodir}/cpio.info.gz %{_infodir}/dir || :
fi

%preun
if [ $1 = 0 ]; then
	if [ -f %{_infodir}/cpio.info.gz ]; then
		/sbin/install-info --delete %{_infodir}/cpio.info.gz %{_infodir}/dir || :
	fi
fi

%files -f %{name}.lang
%doc AUTHORS ChangeLog NEWS README THANKS TODO COPYING
%{_bindir}/*
%{_mandir}/man*/*
%{_infodir}/*.info*

%files fivextra
%{prefix}

%changelog
* Thu Jun 06 2013 baseuser@ibm.com
- Base-8.x spec file
