Summary:	JavaScript interpreter and libraries
Name:		mozjs17
Version:	17.0.0
%define base_release .2
Release:	7%{?dist}%{?base_release}
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License:	GPLv2+ or LGPLv2+ or MPLv1.1
Group:		Development/Languages
URL:		http://www.mozilla.org/js/
Source0:	http://ftp.mozilla.org/pub/mozilla.org/js/mozjs%{version}.tar.gz
BuildRequires:	pkgconfig(nspr)
BuildRequires:	readline-devel
BuildRequires:	/usr/bin/zip
BuildRequires:	/usr/bin/python
BuildRequires:	/usr/bin/autoconf-2.13

Patch0:		js17-build-fixes.patch
# makes mozjs to match js from xul 21
Patch1:		js17-jsval.patch
Patch2:         mozbug746112-no-decommit-on-large-pages.patch

%description
JavaScript is the Netscape-developed object scripting language used in millions
of web pages and server applications worldwide. Netscape's JavaScript is a
superset of the ECMA-262 Edition 3 (ECMAScript) standard scripting language,
with only mild differences from the published standard.

%package devel
Summary: Header files, libraries and development documentation for %{name}
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}

%description devel
This package contains the header files, static libraries and development
documentation for %{name}. If you like to develop programs using %{name},
you will need to install %{name}-devel.

%prep
%setup -q -n mozjs%{version}
# Delete bundled sources
rm js/src/editline -rf
rm js/src/ctypes/libffi -rf
%patch0 -p1
%patch1 -p1
%patch2 -p1
chmod a+x configure
(cd js/src && autoconf-2.13)

%build
%configure --disable-static --with-system-nspr --enable-threadsafe --enable-readline
make %{?_smp_mflags}

%check
cat > js/src/config/find_vanilla_new_calls << EOF
#!/bin/bash
exit 0
EOF
make -C js/src check

%install
make install DESTDIR=%{buildroot}
# For some reason the headers and pkg-config file are executable
find %{buildroot}%{_includedir} -type f -exec chmod a-x {} \;
chmod a-x  %{buildroot}%{_libdir}/pkgconfig/*.pc
# Upstream does not honor --disable-static yet
rm -f %{buildroot}%{_libdir}/*.a
# This is also statically linked; once that is fixed that we could
# consider shipping it.
rm -f %{buildroot}%{_bindir}/js17

# However, delete js-config since everything should use
# the pkg-config file.
rm -f %{buildroot}%{_bindir}/js17-config

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%doc LICENSE README
%{_libdir}/*.so

%files devel
%{_libdir}/pkgconfig/*.pc
%{_includedir}/js-17.0

%changelog
* Thu Jul 11 2013 baseuser@ibm.com
- Base-8.x spec file
