Name:                   libconfig
Summary:                C/C++ configuration file library
Version:                1.4.9
%define base_release .4
Release:                2%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License:                LGPLv2+
Group:                  System Environment/Libraries
Source0:                http://www.hyperrealm.com/libconfig/libconfig-%{version}.tar.gz
Source999:		fivextra.tar.bz2

Patch999:		add-error-capture-for-tests

URL:                    http://www.hyperrealm.com/libconfig/
BuildRequires:          texinfo-tex
BuildRequires:		bison, flex

%description
Libconfig is a simple library for manipulating structured configuration
files. This file format is more compact and more readable than XML. And
unlike XML, it is type-aware, so it is not necessary to do string parsing
in application code.

%package devel
Summary:                Development files for libconfig
Group:                  Development/Libraries
Requires:               %{name} = %{version}-%{release}
Requires:               pkgconfig
Requires(post):         /sbin/install-info
Requires(preun):        /sbin/install-info

%description devel
Development libraries and headers for developing software against
libconfig.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999
%patch999 -p1
iconv -f iso-8859-1 -t utf-8 -o AUTHORS{.utf8,}
mv AUTHORS{.utf8,}

%build
%configure --disable-static
make %{?_smp_mflags}
make pdf

%install
make DESTDIR=$RPM_BUILD_ROOT install install-pdf
rm -rf $RPM_BUILD_ROOT%{_libdir}/*.la
rm -rf $RPM_BUILD_ROOT%{_infodir}/dir
# Prevent multilib conflicts
sed -i '/^\/CreationDate/d' $RPM_BUILD_ROOT%{_defaultdocdir}/%{name}/libconfig.pdf
sed -i '/^\/ModDate/d' $RPM_BUILD_ROOT%{_defaultdocdir}/%{name}/libconfig.pdf
sed -i '/^\/ID /d' $RPM_BUILD_ROOT%{_defaultdocdir}/%{name}/libconfig.pdf

for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

pushd examples/c/.libs
install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/test/c
install * $RPM_BUILD_ROOT/%{fivdir}/%{name}/test/c
popd

pushd examples/c++/.libs
install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/test/c++
install * $RPM_BUILD_ROOT/%{fivdir}/%{name}/test/c++
popd

install -m 755 examples/c/example.cfg $RPM_BUILD_ROOT/%{fivdir}/%{name}/test/c
install -m 755 examples/c++/example.cfg $RPM_BUILD_ROOT/%{fivdir}/%{name}/test/c++

pushd tests/.libs
install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests/
install * $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests/
popd

install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests/testdata
install -m 755 $(find tests/testdata/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests/testdata/ || true

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd 

find $RPM_BUILD_ROOT/%{fivdir}/%{name}/ -name '*.o' -o -name '*.c' -o -name 'Makefile*'  | xargs rm -rf

%post -p /sbin/ldconfig

%post devel
/sbin/install-info %{_infodir}/%{name}.info %{_infodir}/dir || :

%postun -p /sbin/ldconfig

%preun devel
if [ $1 = 0 ]; then
   /sbin/install-info --delete %{_infodir}/%{name}.info %{_infodir}/dir || :
fi

%files
%defattr(-,root,root,-)
%doc AUTHORS ChangeLog COPYING.LIB README
%{_libdir}/libconfig*.so.*


%files devel
%defattr(-,root,root,-)
%{_includedir}/libconfig*
%{_libdir}/libconfig*.so
%{_libdir}/pkgconfig/libconfig*.pc
%{_defaultdocdir}/%{name}/
%{_infodir}/libconfig.info*

%files fivextra
%{prefix}

%changelog
* Mon May 20 2013 baseuser@ibm.com
- Base-8.x spec file
