%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}

# if 0%{?fedora} > 12
# global with_python3 1
# endif

Summary: Create deltas between rpms
Name: deltarpm
Version: 3.6
%define base_release .4
Release: 0.12.20110223git%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: %{cross_arches}
License: BSD
Group: System Environment/Base
URL: http://gitorious.org/deltarpm/deltarpm
# Generate source by doing:
# git clone git://gitorious.org/deltarpm/deltarpm
# cd deltarpm
# git archive --format=tar --prefix="deltarpm-git-20110223/" 7ed5208166 | \
#   bzip2 > deltarpm-git-20110223.tar.bz2
Source: %{name}-git-20110223.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: bzip2-devel, xz-devel, rpm-devel, popt-devel
BuildRequires: zlib-devel
BuildRequires: python-devel

%if 0%{?with_python3}
BuildRequires: python3-devel
%endif

%description
A deltarpm contains the difference between an old
and a new version of a rpm, which makes it possible
to recreate the new rpm from the deltarpm and the old
one. You don't have to have a copy of the old rpm,
deltarpms can also work with installed rpms.

%package -n drpmsync
Summary: Sync a file tree with deltarpms
Group: System Environment/Base
Requires: deltarpm = %{version}-%{release}

%description -n drpmsync
This package contains a tool to sync a file tree with
deltarpms.

%package -n deltaiso
Summary: Create deltas between isos containing rpms
Group: System Environment/Base
Requires: deltarpm = %{version}-%{release}

%description -n deltaiso
This package contains tools for creating and using deltasisos,
a difference between an old and a new iso containing rpms.

%package -n python-deltarpm
Summary: Python bindings for deltarpm
Group: System Environment/Base
Requires: deltarpm = %{version}-%{release}

%description -n python-deltarpm
This package contains python bindings for deltarpm.

%if 0%{?with_python3}
%package -n python3-deltarpm
Summary: Python bindings for deltarpm
Group: System Environment/Base
Requires: deltarpm = %{version}-%{release}

%description -n python3-deltarpm
This package contains python bindings for deltarpm.
%endif


%prep
%setup -q -n %{name}-git-20110223

%build
%{__make} %{?_smp_mflags} CFLAGS="$RPM_OPT_FLAGS" \
    bindir=%{_bindir} libdir=%{_libdir} mandir=%{_mandir} prefix=%{_prefix} \
    zlibbundled='' zlibldflags='-lz' zlibcppflags=''
%{__make} %{?_smp_mflags} CFLAGS="$RPM_OPT_FLAGS" \
    bindir=%{_bindir} libdir=%{_libdir} mandir=%{_mandir} prefix=%{_prefix} \
    zlibbundled='' zlibldflags='-lz' zlibcppflags='' \
    python

%install
%{__rm} -rf %{buildroot}
%makeinstall pylibprefix=%{buildroot}

%if 0%{?with_python3}
# nothing to do
%else
rm -rf %{buildroot}%{_libdir}/python3*
%endif


%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-, root, root, 0755)
%doc LICENSE.BSD README
%doc %{_mandir}/man8/applydeltarpm*
%doc %{_mandir}/man8/makedeltarpm*
%doc %{_mandir}/man8/combinedeltarpm*
%{_bindir}/applydeltarpm
%{_bindir}/combinedeltarpm
%{_bindir}/makedeltarpm
%{_bindir}/rpmdumpheader

%files -n deltaiso
%defattr(-, root, root, 0755)
%doc LICENSE.BSD README
%doc %{_mandir}/man8/applydeltaiso*
%doc %{_mandir}/man8/makedeltaiso*
%{_bindir}/applydeltaiso
%{_bindir}/fragiso
%{_bindir}/makedeltaiso

%files -n drpmsync
%defattr(-, root, root, 0755)
%doc LICENSE.BSD README
%doc %{_mandir}/man8/drpmsync*
%{_bindir}/drpmsync

%files -n python-deltarpm
%defattr(-, root, root, 0755)
%doc LICENSE.BSD
%{python_sitearch}/*

%if 0%{?with_python3}

%files -n python3-deltarpm
%defattr(-, root, root, 0755)
%doc LICENSE.BSD
%{python3_sitearch}/*

%endif

%changelog
* Thu May 16 2013 baseuser@ibm.com
- Base-8.x spec file
