Name:           perl-libwww-perl
Version:        6.05
%define base_release .3
Release:        1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: %{cross_arches}
Summary:        A Perl interface to the World-Wide Web
Group:          Development/Libraries
License:        GPL+ or Artistic
URL:            http://search.cpan.org/dist/libwww-perl/
Source0:        http://www.cpan.org/authors/id/G/GA/GAAS/libwww-perl-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  perl(Digest::MD5)
BuildRequires:  perl(Encode) >= 2.12
BuildRequires:  perl(Encode::Locale)
BuildRequires:  perl(Exporter)
BuildRequires:  perl(File::Listing) >= 6
BuildRequires:  perl(ExtUtils::MakeMaker)
BuildRequires:  perl(HTML::Entities)
BuildRequires:  perl(HTML::HeadParser)
BuildRequires:  perl(HTTP::Cookies) >= 6
BuildRequires:  perl(HTTP::Daemon) >= 6
BuildRequires:  perl(HTTP::Date) >= 6
BuildRequires:  perl(HTTP::Negotiate) >= 6
BuildRequires:  perl(HTTP::Request) >= 6
BuildRequires:  perl(HTTP::Request::Common) >= 6
BuildRequires:  perl(HTTP::Response) >= 6
BuildRequires:  perl(HTTP::Status) >= 6
BuildRequires:  perl(IO::Select)
BuildRequires:  perl(IO::Socket)
BuildRequires:  perl(LWP::MediaTypes) >= 6
BuildRequires:  perl(MIME::Base64) >= 2.1
BuildRequires:  perl(Net::FTP) >= 2.58
BuildRequires:  perl(Net::HTTP) >= 6.04
BuildRequires:  perl(URI) >= 1.10
BuildRequires:  perl(URI::Escape)
BuildRequires:  perl(WWW::RobotRules) >= 6
# Tests only:
BuildRequires:  perl(Config)
BuildRequires:  perl(Test::More)
Requires:       perl(:MODULE_COMPAT_%(eval "`perl -V:version`"; echo $version))
Requires:       perl(Encode) >= 2.12
Requires:       perl(File::Listing) >= 6
Requires:       perl(HTML::Entities)
Requires:       perl(HTML::HeadParser)
Requires:       perl(HTTP::Cookies) >= 6
Requires:       perl(HTTP::Daemon) >= 6
Requires:       perl(HTTP::Date) >= 6
Requires:       perl(HTTP::Negotiate) >= 6
Requires:       perl(HTTP::Request) >= 6
Requires:       perl(HTTP::Request::Common) >= 6
Requires:       perl(HTTP::Response) >= 6
Requires:       perl(HTTP::Status) >= 6
Requires:       perl(LWP::MediaTypes) >= 6
Requires:       perl(MIME::Base64) >= 2.1
Requires:       perl(Net::FTP) >= 2.58
Requires:       perl(Net::HTTP) >= 6.04
Requires:       perl(URI) >= 1.10
Requires:       perl(URI::Escape)
Requires:       perl(WWW::RobotRules) >= 6

%description
The libwww-perl collection is a set of Perl modules which provides a simple and
consistent application programming interface to the World-Wide Web.  The main
focus of the library is to provide classes and functions that allow you to
write WWW clients. The library also contain modules that are of more general
use and even classes that help you implement simple HTTP servers.

# Remove not-packaged features
%global __requires_exclude %{?__requires_exclude:%__requires_exclude|}perl\\(Authen::NTLM\\)
%global __requires_exclude %__requires_exclude|perl\\(HTTP::GHTTP\\)
# Remove underspecified dependencies
%global __requires_exclude %__requires_exclude|^perl\\(Encode\\)\\s*$
%global __requires_exclude %__requires_exclude|^perl\\(File::Listing\\)\\s*$
%global __requires_exclude %__requires_exclude|^perl\\(HTTP::Date\\)\\s*$
%global __requires_exclude %__requires_exclude|^perl\\(HTTP::Negotiate\\)\\s*$
%global __requires_exclude %__requires_exclude|^perl\\(HTTP::Request\\)\\s*$
%global __requires_exclude %__requires_exclude|^perl\\(HTTP::Response\\)\\s*$
%global __requires_exclude %__requires_exclude|^perl\\(HTTP::Status\\)\\s*$
%global __requires_exclude %__requires_exclude|^perl\\(LWP::MediaTypes\\)\\s*$
%global __requires_exclude %__requires_exclude|^perl\\(MIME::Base64\\)\\s*$
%global __requires_exclude %__requires_exclude|^perl\\(Net::HTTP\\)\\s*$
%global __requires_exclude %__requires_exclude|^perl\\(URI\\)\\s*$
%global __requires_exclude %__requires_exclude|^perl\\(WWW::RobotRules\)\\s*$

%prep
%setup -q -n libwww-perl-%{version} 

%build
# Install the aliases by default
perl Makefile.PL INSTALLDIRS=perl --aliases < /dev/null
make %{?_smp_mflags}

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} ';'
chmod -R u+w $RPM_BUILD_ROOT/*

%check
# Some optional tests require resolvable hostname
make test

%files
%doc AUTHORS Changes README*
%{_bindir}/*
%{perl_privlib}/lwp*.pod
%{perl_privlib}/LWP.pm
%{perl_privlib}/LWP/
%{_mandir}/man1/*.1*
%{_mandir}/man3/*.3*

%changelog
* Thu Jun 27 2013 baseuser@ibm.com
- Base-8.x spec file
