%global debug_package %{nil}
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

Name:           system-config-keyboard
Version:        1.3.1
%define base_release .3
Release:        14%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:        A graphical interface for modifying the keyboard

Group:          System Environment/Base
License:        GPLv2+
URL:            https://fedorahosted.org/system-config-keyboard/
Source0:        https://fedorahosted.org/releases/s/y/system-config-keyboard/%{name}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  desktop-file-utils
BuildRequires:  gettext
BuildRequires:  intltool

Requires:       system-config-keyboard-base = %{version}-%{release}
Requires:       newt-python
Requires:       usermode >= 1.36
Requires:       polkit

Obsoletes:      kbdconfig
Obsoletes:      redhat-config-keyboard
Patch0:         system-config-keyboard-1.3.1-do_not_remove_the_OK_button.patch
Patch1:         system-config-keyboard-1.3.1-no-pyxf86config.patch
Patch2:         system-config-keyboard-1.3.1-pkexec.patch
Patch3:         system-config-keyboard-1.3.1-manpage.patch
Patch4:         system-config-keyboard-1.3.1-use_systemd_localed_config.patch


%description
system-config-keyboard is a graphical user interface that allows 
the user to change the default keyboard of the system.


%package base 	 
Summary:        system-config-keyboard base components 	 
Group:          System Environment/Base 	 
License:        GPLv2+ 	 
Requires:       python 	 
Requires:       dbus-python 	 
	  	 
%description base 	 
Base components of system-config-keyboard.

%prep
%setup -q
%patch0 -p1 -b .do_not_remove_the_OK_button
%patch1 -p1 -b .no-pyxf86config
%patch2 -p1 -b .pkexec
%patch3 -p1 -b .manpage
%patch4 -p1 -b .use_systemd_localed_config

%build
make


%install
rm -rf $RPM_BUILD_ROOT
make INSTROOT=$RPM_BUILD_ROOT install
desktop-file-install --vendor system --delete-original      \
  --dir $RPM_BUILD_ROOT%{_datadir}/applications             \
   $RPM_BUILD_ROOT%{_datadir}/applications/system-config-keyboard.desktop

%find_lang %{name}


%clean
rm -rf $RPM_BUILD_ROOT


%post
touch --no-create %{_datadir}/icons/hicolor
if [ -x /usr/bin/gtk-update-icon-cache ]; then
  gtk-update-icon-cache -q %{_datadir}/icons/hicolor
fi


%postun
touch --no-create %{_datadir}/icons/hicolor
if [ -x /usr/bin/gtk-update-icon-cache ]; then
  gtk-update-icon-cache -q %{_datadir}/icons/hicolor
fi


%files 
%defattr(-,root,root)
%{_sbindir}/system-config-keyboard
%{_bindir}/system-config-keyboard
%{_datadir}/system-config-keyboard
%attr(0755,root,root) %dir %{_datadir}/firstboot/modules
%{_datadir}/firstboot/modules/*
%attr(0644,root,root) %{_datadir}/applications/system-config-keyboard.desktop
%attr(0644,root,root) %{_datadir}/polkit-1/actions/org.fedoraproject.config.keyboard.policy
%attr(0644,root,root) %{_datadir}/icons/hicolor/48x48/apps/system-config-keyboard.png
%{_datadir}/man/man*/system-config-keyboard.*

%files base -f %{name}.lang
%defattr(-,root,root)
%doc COPYING
%{python_sitelib}/system_config_keyboard


%changelog
* Thu Jul 11 2013 baseuser@ibm.com
- Base-8.x spec file
