%define	fontname	smc

# Common description
%define common_desc \
The SMC Fonts package contains fonts for the display of\
traditional and new Malayalam Script.

Name:		%{fontname}-fonts
Version:	5.0.1
%define base_release .1
Release:	5%{?dist}%{?base_release}
Summary:	Open Type Fonts for Malayalam script
Group:		User Interface/X
License:	GPLv3+ with exceptions and GPLv2+ with exceptions and GPLv2+ and  GPLv2 and GPL+
URL:		http://savannah.nongnu.org/projects/smc
Source0:	http://download.savannah.gnu.org/releases-noredirect/smc/fonts/malayalam-fonts-%{version}.tar.gz
Source1: 65-0-smc-meera.conf
Source2: 67-smc-anjalioldlipi.conf
Source3: 67-smc-dyuthi.conf
Source4: 67-smc-kalyani.conf
Source5: 65-0-smc-rachana.conf
Source6: 67-smc-raghumalayalam.conf
Source7: 67-smc-suruma.conf
Source8: AnjaliOldLipi-license-confirmation-email.txt
BuildArch:	noarch
BuildRequires:	fontpackages-devel > 1.13
BuildRequires:	fontforge >= 20080429
Patch1: bug-803234.patch

%description
%common_desc

%package common
Summary:  Common files for smc-fonts
Group:	User Interface/X
Requires: fontpackages-filesystem

%description common
%common_desc

%package -n %{fontname}-dyuthi-fonts
Summary: Open Type Fonts for Malayalam script
Group: User Interface/X 
Requires: %{name}-common = %{version}-%{release}
License: GPLv3+ with exceptions
%description -n %{fontname}-dyuthi-fonts
The Dyuthi font package contains fonts for the display of
traditional Malayalam Scripts.

%_font_pkg -n dyuthi -f 67-smc-dyuthi.conf Dyuthi*.ttf 

%package -n %{fontname}-meera-fonts
Summary: Open Type Fonts for Malayalam script
Group: User Interface/X 
Requires: %{name}-common = %{version}-%{release}
License: GPLv2+ with exceptions
%description -n %{fontname}-meera-fonts
The Meera font package contains fonts for the display of
traditional Malayalam Scripts.

%_font_pkg -n meera -f 65-0-smc-meera.conf Meera.ttf 
%doc Meera/COPYING Meera/README


%package -n %{fontname}-rachana-fonts
Summary: Open Type Fonts for Malayalam script
Group: User Interface/X 
Requires: %{name}-common = %{version}-%{release}
License: GPLv2+
%description -n %{fontname}-rachana-fonts
The Rachana font package contains fonts for the display of
traditional Malayalam Scripts.

%_font_pkg -n rachana -f 65-0-smc-rachana.conf Rachana.ttf
%doc Rachana/COPYING Rachana/LICENSE Rachana/README


%package -n %{fontname}-raghumalayalam-fonts
Summary: Open Type Fonts for Malayalam script
Group: User Interface/X 
Requires: %{name}-common = %{version}-%{release}
License: GPLv2
%description -n %{fontname}-raghumalayalam-fonts
The SMC Malayalam fonts package contains fonts for the display of
new Malayalam Scripts.

%_font_pkg -n raghumalayalam -f 67-smc-raghumalayalam.conf RaghuMalayalamSans.ttf

%package -n %{fontname}-suruma-fonts
Summary: Open Type Fonts for Malayalam script
Group: User Interface/X 
Requires: %{name}-common = %{version}-%{release}
License: GPLv3 with exceptions
%description -n %{fontname}-suruma-fonts
The Suruma font package contains fonts for the display of
traditional Malayalam Scripts.

%_font_pkg -n suruma -f 67-smc-suruma.conf Suruma.ttf

%package -n %{fontname}-kalyani-fonts
Summary: Open Type Fonts for Malayalam script
Group: User Interface/X
Requires: %{name}-common = %{version}-%{release}
License: GPLv3+ with exceptions
%description -n %{fontname}-kalyani-fonts
The Kalyani font package contains fonts for the display of
new Malayalam Scripts.

%_font_pkg -n kalyani -f 67-smc-kalyani.conf Kalyani.ttf

%package -n %{fontname}-anjalioldlipi-fonts
Summary: Open Type Fonts for Malayalam script
Group: User Interface/X
Requires: %{name}-common = %{version}-%{release}
License: GPL+
%description -n %{fontname}-anjalioldlipi-fonts
The Anjali OldLipi package contains fonts for the display of
traditional Malayalam Scripts.

%_font_pkg -n anjalioldlipi -f 67-smc-anjalioldlipi.conf AnjaliOldLipi.ttf

#%{_fontdir} is shared by following packages since they all are for malayalam script only

%prep
%setup -q -n malayalam-fonts-%{version}
%patch1 -p1 -b .1-panose-setting

%build
chmod +x generate.pe
make

%install
install -m 0755 -d %{buildroot}%{_fontdir}
install -m 0644 -p AnjaliOldLipi/*.ttf %{buildroot}%{_fontdir}
install -m 0644 -p Dyuthi/*.ttf %{buildroot}%{_fontdir}
install -m 0644 -p Kalyani/*.ttf %{buildroot}%{_fontdir}
install -m 0644 -p Meera/*.ttf %{buildroot}%{_fontdir}
install -m 0644 -p Rachana/*.ttf %{buildroot}%{_fontdir}
install -m 0644 -p RaghuMalayalamSans/*.ttf %{buildroot}%{_fontdir}
install -m 0644 -p Suruma/*.ttf %{buildroot}%{_fontdir}
install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} \
		%{buildroot}%{_fontconfig_confdir}
install -m 0644 -p %{SOURCE1} \
	%{buildroot}%{_fontconfig_templatedir}/65-0-smc-meera.conf
install -m 0644 -p %{SOURCE2} \
	%{buildroot}%{_fontconfig_templatedir}/67-smc-anjalioldlipi.conf
install -m 0644 -p %{SOURCE3} \
	%{buildroot}%{_fontconfig_templatedir}/67-smc-dyuthi.conf
install -m 0644 -p %{SOURCE4} \
	%{buildroot}%{_fontconfig_templatedir}/67-smc-kalyani.conf
install -m 0644 -p %{SOURCE5} \
	%{buildroot}%{_fontconfig_templatedir}/65-0-smc-rachana.conf
install -m 0644 -p %{SOURCE6} \
	%{buildroot}%{_fontconfig_templatedir}/67-smc-raghumalayalam.conf
install -m 0644 -p %{SOURCE7} \
	%{buildroot}%{_fontconfig_templatedir}/67-smc-suruma.conf

for fconf in 65-0-smc-meera.conf \
	     67-smc-anjalioldlipi.conf \
	     67-smc-dyuthi.conf \
	     67-smc-kalyani.conf \
	     65-0-smc-rachana.conf \
	     67-smc-raghumalayalam.conf \
	     67-smc-suruma.conf ; do
  ln -s %{_fontconfig_templatedir}/$fconf \
	%{buildroot}%{_fontconfig_confdir}/$fconf
done



%files common
%doc ChangeLog 

%changelog
* Thu May 29 2014 baseuser@ibm.com
- Base-f19.x spec file
