%define isprerelease 0

%if %isprerelease
%define prerelease pre1
%endif

Summary: A program for synchronizing files over a network
Name: rsync
Version: 3.0.9
%define base_release .3
Release: 8%{?prerelease}%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Group: Applications/Internet
URL: http://rsync.samba.org/

Source0: ftp://rsync.samba.org/pub/rsync/rsync-%{version}%{?prerelease}.tar.gz
Source1: ftp://rsync.samba.org/pub/rsync/rsync-patches-%{version}%{?prerelease}.tar.gz
Source2: rsyncd.socket
Source3: rsyncd.service
Source4: rsyncd.conf
Source5: rsyncd.sysconfig
Source999: fivextra.tar.bz2
BuildRequires: libacl-devel, libattr-devel, autoconf, popt-devel, zlib-devel
Requires: zlib
Requires(post): systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units
License: GPLv3+

Patch0: rsync-3.0.10-lose-track.patch
Patch94658: bug-94658.patch

%description
Rsync uses a reliable algorithm to bring remote and host files into
sync very quickly. Rsync is fast because it just sends the differences
in the files over the network instead of sending the complete
files. Rsync is often used as a very powerful mirroring process or
just as a more capable replacement for the rcp command. A technical
report which describes the rsync algorithm is included in this
package.

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
# TAG: for pre versions use

%if %isprerelease
%setup -q -n rsync-%{version}%{?prerelease}
%setup -q -b 1 -n rsync-%{version}%{?prerelease}
%else
%setup -q
%setup -q -b 1 -a 999
%endif

chmod -x support/*

#Needed for compatibility with previous patched rsync versions
patch -p1 -i patches/acls.diff
patch -p1 -i patches/xattrs.diff

#Enable --copy-devices parameter
patch -p1 -i patches/copy-devices.diff

%patch0 -p1 -b .lose-track

%patch94658 -p1 
%build
rm -fr autom4te.cache
autoconf -o configure.sh
autoheader && touch config.h.in

%configure
    
make proto
make %{?_smp_mflags} CFLAGS="$RPM_OPT_FLAGS"

#make check to build the test executables
make %{?_smp_mflags} check || :

pushd fivextra
make all
popd

%install
rm -rf $RPM_BUILD_ROOT

%makeinstall INSTALLCMD='install -p' INSTALLMAN='install -p'

install -D -m644 %{SOURCE3} $RPM_BUILD_ROOT/%{_unitdir}/rsyncd.service
install -D -m644 %{SOURCE2} $RPM_BUILD_ROOT/%{_unitdir}/rsyncd.socket
install -D -m644 %{SOURCE4} $RPM_BUILD_ROOT/%{_sysconfdir}/rsyncd.conf
install -D -m644 %{SOURCE5} $RPM_BUILD_ROOT/%{_sysconfdir}/sysconfig/rsyncd

# Steps to package the rsync tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find testsuite -type d)
do
  install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -m 755 runtests.sh getfsdev getgroups tls trimslash t_unsafe wildtest shconfig wildtest.txt config.h configure.ac  $RPM_BUILD_ROOT/%{fivdir}/%{name}/
install -m 755 exclude.c flist.c getfsdev.c wildtest.c tls.c $RPM_BUILD_ROOT/%{fivdir}/%{name}/
install -d -m 755 $RPM_BUILD_ROOT/%{fivdir}/%{name}/support/
install -m 755 support/lsh $RPM_BUILD_ROOT/%{fivdir}/%{name}/support/

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc COPYING NEWS OLDNEWS README support/ tech_report.tex
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*
%{_mandir}/man5/rsyncd.conf.5*
%config(noreplace) %{_sysconfdir}/rsyncd.conf
%config(noreplace) %{_sysconfdir}/sysconfig/rsyncd
%{_unitdir}/rsyncd.socket
%{_unitdir}/rsyncd.service

%files fivextra
%{prefix}

%post
%systemd_post rsyncd.service

%preun
%systemd_preun rsyncd.service

%postun
%systemd_postun_with_restart rsyncd.service

%changelog
* Thu Jun 06 2013 baseuser@ibm.com
- Base-8.x spec file
