Name:           seabios
Version:        1.7.2.2
%define base_release .2
Release:        1%{?dist}%{?base_release}
Summary:        Open-source legacy BIOS implementation

Group:          Applications/Emulators
License:        LGPLv3
URL:            http://www.coreboot.org/SeaBIOS

# No source releases of seabios stable. To generate:
# git clone git://git.seabios.org/seabios.git && cd seabios
# git archive --output seabios-1.7.2.2.tar.gz --prefix seabios-1.7.2.2/ rel-1.7.2.2
#Source0:        http://code.coreboot.org/p/seabios/downloads/get/%{name}-%{version}.tar.gz
Source0: seabios-%{version}.tar.gz

Source10:       config.vga.cirrus
Source11:       config.vga.isavga
Source12:       config.vga.qxl
Source13:       config.vga.stdvga
Source14:       config.vga.vmware

BuildRequires: python iasl
BuildRequires: binutils-x86_64-linux-gnu gcc-x86_64-linux-gnu

Requires: %{name}-bin = %{version}-%{release}
Requires: seavgabios-bin = %{version}-%{release}
Buildarch: noarch

# Seabios is noarch, but required on architectures which cannot build it.
# Disable debuginfo because it is of no use to us.
%global debug_package %{nil}

# You can build a debugging version of the BIOS by setting this to a
# value > 1.  See src/config.h for possible values, but setting it to
# a number like 99 will enable all possible debugging.  Note that
# debugging goes to a special qemu port that you have to enable.  See
# the SeaBIOS top-level README file for the magic qemu invocation to
# enable this.
%global debug_level 1


%description
SeaBIOS is an open-source legacy BIOS implementation which can be used as
a coreboot payload. It implements the standard BIOS calling interfaces
that a typical x86 proprietary BIOS implements.


%package bin
Summary: Seabios for x86
Buildarch: noarch


%description bin
SeaBIOS is an open-source legacy BIOS implementation which can be used as
a coreboot payload. It implements the standard BIOS calling interfaces
that a typical x86 proprietary BIOS implements.


%package -n seavgabios-bin
Summary: Seavgabios for x86
Buildarch: noarch
Obsoletes: vgabios < vgabios-0.6c-10
Provides: vgabios = vgabios-0.6c-10

%description -n seavgabios-bin
SeaVGABIOS is an open-source VGABIOS implementation.


%prep
%setup -q

# Makefile changes version to include date and buildhost
sed -i 's,VERSION=%{version}.*,VERSION=%{version},g' Makefile


%build
make .config V=1
sed -i 's,CONFIG_DEBUG_LEVEL=.*,CONFIG_DEBUG_LEVEL=%{debug_level},g' .config

export CFLAGS="$RPM_OPT_FLAGS"
mkdir binaries

# seabios
make V=1 \
	HOSTCC=gcc \
	CC=x86_64-linux-gnu-gcc \
	AS=x86_64-linux-gnu-as \
	LD=x86_64-linux-gnu-ld \
	OBJCOPY=x86_64-linux-gnu-objcopy \
	OBJDUMP=x86_64-linux-gnu-objdump \
	STRIP=x86_64-linux-gnu-strip
cp out/bios.bin binaries

# seavgabios
for config in %{SOURCE10} %{SOURCE11} %{SOURCE12} %{SOURCE13} %{SOURCE14}; do
	name=${config#*config.vga.}
	make clean distclean
	cp ${config} .config
	echo "CONFIG_DEBUG_LEVEL=%{debug_level}" >> .config
	make oldnoconfig
	make V=1 \
		HOSTCC=gcc \
		CC=x86_64-linux-gnu-gcc \
		AS=x86_64-linux-gnu-as \
		LD=x86_64-linux-gnu-ld \
		OBJCOPY=x86_64-linux-gnu-objcopy \
		OBJDUMP=x86_64-linux-gnu-objdump \
		STRIP=x86_64-linux-gnu-strip \
		out/vgabios.bin
	cp out/vgabios.bin binaries/vgabios-${name}.bin
done


%install
mkdir -p $RPM_BUILD_ROOT%{_datadir}/seabios
mkdir -p $RPM_BUILD_ROOT%{_datadir}/seavgabios
install -m 0644 binaries/bios.bin $RPM_BUILD_ROOT%{_datadir}/seabios
install -m 0644 binaries/vgabios*.bin $RPM_BUILD_ROOT%{_datadir}/seavgabios


%files
%doc COPYING COPYING.LESSER README TODO


%files bin
%dir %{_datadir}/seabios/
%{_datadir}/seabios/bios.bin

%files -n seavgabios-bin
%dir %{_datadir}/seavgabios/
%{_datadir}/seavgabios/vgabios*.bin


%changelog
* Tue Jul 09 2013 baseuser@ibm.com
- Base-8.x spec file
