Name:		perl-IO-Socket-SSL
Version:	1.88
%define base_release .2
Release:	1%{?dist}%{?base_release}
Summary:	Perl library for transparent SSL
Group:		Development/Libraries
License:	GPL+ or Artistic
URL:		http://search.cpan.org/dist/IO-Socket-SSL/
Source0:	http://search.cpan.org/CPAN/authors/id/S/SU/SULLR/IO-Socket-SSL-%{version}.tar.gz
Source999:     fivextra.tar.bz2
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(id -nu)
BuildArch:	noarch
BuildRequires:	perl(Carp)
BuildRequires:	perl(constant)
BuildRequires:	perl(Exporter)
BuildRequires:	perl(ExtUtils::MakeMaker)
BuildRequires:	perl(IO::Select)
BuildRequires:	perl(IO::Socket)
BuildRequires:	perl(IO::Socket::INET)
BuildRequires:	perl(IO::Socket::INET6)
BuildRequires:	perl(Net::LibIDN)
BuildRequires:	perl(Net::SSLeay) >= 1.21
BuildRequires:	perl(Pod::Man)
BuildRequires:	perl(Scalar::Util)
BuildRequires:	perl(Socket)
BuildRequires:	perl(Socket6)
BuildRequires:	procps
# Use IO::Socket::IP for IPv6 support where available, else IO::Socket::INET6
%if 0%{?fedora} > 15 || 0%{?rhel} > 6
BuildRequires:	perl(IO::Socket::IP) >= 0.11, perl(Socket) >= 1.95
Requires:	perl(IO::Socket::IP) >= 0.11, perl(Socket) >= 1.95
%else
Requires:	perl(IO::Socket::INET6), perl(Socket6)
%endif
Requires:	perl(:MODULE_COMPAT_%(eval "`perl -V:version`"; echo $version))
Requires:	perl(Net::LibIDN)

%description
This module is a true drop-in replacement for IO::Socket::INET that
uses SSL to encrypt data before it is transferred to a remote server
or client. IO::Socket::SSL supports all the extra features that one
needs to write a full-featured SSL client or server application:
multiple SSL contexts, cipher selection, certificate verification, and
SSL version selection. As an extra bonus, it works perfectly with
mod_perl.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -n IO-Socket-SSL-%{version} -a 999

%build
perl Makefile.PL INSTALLDIRS=vendor
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
rm -rf %{buildroot}
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} ';'
%{_fixperms} %{buildroot}

# Steps to package the perl-IO-Socket-SSL tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find t -type d)
do
 install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
 install -m 755 $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find certs -type d)
do
 install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
 install -m 755 $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
make test

%clean
rm -rf %{buildroot}

%files
%doc BUGS Changes README docs/ certs/ example/ util/
%{perl_vendorlib}/IO/
%{_mandir}/man3/IO::Socket::SSL.3pm*

%files fivextra
%{prefix}

%changelog
* Wed Jul 03 2013 baseuser@ibm.com
- Base-8.x spec file
