Name:         ipmitool
Summary:      Utility for IPMI control
Version:      1.8.13
%define base_release .2
Release:      3%{?dist}%{?base_release}
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License:      BSD
Group:        System Environment/Base
URL:          http://ipmitool.sourceforge.net/
Source0:      http://downloads.sourceforge.net/project/%{name}/%{name}/%{version}/%{name}-%{version}.tar.bz2
Source1:      openipmi-ipmievd.sysconf
Source2:      ipmievd.service
Source3:      exchange-bmc-os-info.service
Source4:      exchange-bmc-os-info.sysconf
Source5:      set-bmc-url.sh
Source6:      exchange-bmc-os-info
Source999:    fivextra.tar.bz2

BuildRequires: openssl-devel readline-devel ncurses-devel
BuildRequires: systemd-units
# bootstrap
BuildRequires: automake autoconf libtool
Requires:OpenIPMI-modalias
Requires(post): systemd-sysv
Requires(post): systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units
Obsoletes: OpenIPMI-tools < 2.0.14-3
Provides: OpenIPMI-tools = 2.0.14-3

Patch1: ipmitool-1.8.10-ipmievd-init.patch
Patch2: ipmitool-1.8.10-ipmievd-condrestart.patch
Patch3: ipmitool-1.8.11-remove-umask0.patch
# various threads. still pending.
Patch4: cxoem-jb-cx6.patch
# pending
#Patch5: ipmitool-1.8.12-fips.patch
# pending
#Patch6: ipmitool-1.8.12-fipsman.patch
# pending https://sourceforge.net/p/ipmitool/bugs/280/
Patch7: ipmitool-1.8.13-dualbridgedoc.patch
#Patch104955: bug104955.p8.enablement.patch
Patch1049551: bug104955-dont.print.outdated.sel.record.patch
Patch1049552: bug104955-lanplus.retry.patch
Patch1049553: bug104955-fix.segv.in.lanplus.patch
Patch1049554: bug104955-fix.segv.in.ipmi_main.patch


%description
This package contains a utility for interfacing with devices that support
the Intelligent Platform Management Interface specification.  IPMI is
an open standard for machine health, inventory, and remote power control.

This utility can communicate with IPMI-enabled devices through either a
kernel driver such as OpenIPMI or over the RMCP LAN protocol defined in
the IPMI specification.  IPMIv2 adds support for encrypted LAN
communications and remote Serial-over-LAN functionality.

It provides commands for reading the Sensor Data Repository (SDR) and
displaying sensor values, displaying the contents of the System Event
Log (SEL), printing Field Replaceable Unit (FRU) information, reading and
setting LAN configuration, and chassis power control.

%package -n bmc-snmp-proxy
Requires: net-snmp
Requires: exchange-bmc-os-info
Requires:OpenIPMI-modalias
BuildArch: noarch
Summary: Reconfigure SNMP to include host SNMP agent within BMC
%description -n bmc-snmp-proxy
Given a host with BMC, this package would extend system configuration
of net-snmp to include redirections to BMC based SNMP.


%package -n exchange-bmc-os-info
Requires: hostname
Requires: ipmitool OpenIPMI
Requires:OpenIPMI-modalias
BuildArch: noarch
Requires(post): systemd-sysv
Requires(post): systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units

Summary: Let OS and BMC exchange info

%description -n exchange-bmc-os-info
Given a host with BMC, this package would pass the hostname &
OS information to the BMC and also capture the BMC ip info
for the host OS to use.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep

%setup -q -a 999
%patch1 -p1 -b .ipmievd-init
%patch2 -p0 -b .condrestart
%patch3 -p1 -b .umask
%patch4 -p1 -b .cxoem
#patch5 -p0 -b .fips
#patch6 -p0 -b .fipsman
%patch7 -p1 -b .dualbridgedoc

# Update from bug 104955
#%patch104955 -p1  # Replace this patch with the following four.
%patch1049551 -F1 -p1
%patch1049552 -p2
%patch1049553 -p2
%patch1049554 -p2

for f in AUTHORS ChangeLog; do
    iconv -f iso-8859-1 -t utf8 < ${f} > ${f}.utf8
    mv ${f}.utf8 ${f}
done

%build
# --disable-dependency-tracking speeds up the build
# --enable-file-security adds some security checks
# --disable-intf-free disables FreeIPMI support - we don't want to depend on
#   FreeIPMI libraries, FreeIPMI has its own ipmitoool-like utility.

# begin: release auto-tools
# Used to be needed by aarch64 support, now only cxoem patch makefiles are left.
aclocal
libtoolize --automake --copy
autoheader
automake --foreign --add-missing --copy
aclocal
autoconf
automake --foreign
# end: release auto-tools

%configure --disable-dependency-tracking --enable-file-security --disable-intf-free
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make DESTDIR=%{buildroot} install

install -Dpm 644 %{SOURCE2} %{buildroot}%{_unitdir}/ipmievd.service
install -Dpm 644 %{SOURCE1} %{buildroot}%{_sysconfdir}/sysconfig/ipmievd
install -Dm 644 %{SOURCE3} %{buildroot}%{_unitdir}/exchange-bmc-os-info.service
install -Dm 644 %{SOURCE4} %{buildroot}%{_sysconfdir}/sysconfig/exchange-bmc-os-info
install -Dm 644 %{SOURCE5} %{buildroot}%{_sysconfdir}/profile.d/set-bmc-url.sh
install -Dm 755 %{SOURCE6} %{buildroot}%{_libexecdir}/exchange-bmc-os-info


install -Dm 644 contrib/bmc-snmp-proxy.sysconf %{buildroot}%{_sysconfdir}/sysconfig/bmc-snmp-proxy
install -Dm 644 contrib/bmc-snmp-proxy.service %{buildroot}%{_unitdir}/bmc-snmp-proxy.service
install -Dm 755 contrib/bmc-snmp-proxy         %{buildroot}%{_libexecdir}/bmc-snmp-proxy

# Steps to package the ipmitool tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd


%post
%systemd_post ipmievd.service

%preun
%systemd_preun ipmievd.service

%postun
%systemd_postun_with_restart ipmievd.service

%post -n exchange-bmc-os-info
%systemd_post exchange-bmc-os-info.service

%preun -n exchange-bmc-os-info
%systemd_preun exchange-bmc-os-info.service

%postun -n exchange-bmc-os-info
%systemd_postun_with_restart exchange-bmc-os-info.service


%triggerun -- ipmievd < 1.8.11-7
# Save the current service runlevel info
# User must manually run systemd-sysv-convert --apply ipmievd
# to migrate them to systemd targets
/usr/bin/systemd-sysv-convert --save ipmievd >/dev/null 2>&1 ||:

# Run these because the SysV package being removed won't do them
/sbin/chkconfig --del ipmievd >/dev/null 2>&1 || :
/bin/systemctl try-restart ipmievd.service >/dev/null 2>&1 || :

%files
%config(noreplace) %{_sysconfdir}/sysconfig/ipmievd
%{_unitdir}/ipmievd.service
%{_bindir}/*
%{_sbindir}/*
%{_mandir}/man*/*
%doc %{_datadir}/doc/ipmitool
%{_datadir}/ipmitool

%files -n exchange-bmc-os-info
%config(noreplace) %{_sysconfdir}/sysconfig/exchange-bmc-os-info
%{_sysconfdir}/profile.d/set-bmc-url.sh
%{_unitdir}/exchange-bmc-os-info.service
%{_libexecdir}/exchange-bmc-os-info

%files -n bmc-snmp-proxy
%config(noreplace) %{_sysconfdir}/sysconfig/bmc-snmp-proxy
%{_unitdir}/bmc-snmp-proxy.service
%{_libexecdir}/bmc-snmp-proxy

%files fivextra
%{prefix}


%changelog
* Mon Mar 03 2014 baseuser@ibm.com
- Base-f19.x spec file
