%if ! 0%{?base}
%global with_python3 1
%endif

%global modname dogpile.core

Name:               python-dogpile-core
Version:            0.4.1
%define base_release .1
Release:            2%{?dist}%{?base_release}
Summary:            A 'dogpile' lock, typically used as a component of a larger caching solution

Group:              Development/Libraries
License:            BSD
URL:                http://pypi.python.org/pypi/dogpile.core
Source0:            http://pypi.python.org/packages/source/d/%{modname}/%{modname}-%{version}.tar.gz

BuildArch:          noarch


BuildRequires:      python2-devel
BuildRequires:      python-setuptools
BuildRequires:      python-nose

%if 0%{?with_python3}
BuildRequires:      python3-devel
BuildRequires:      python3-setuptools
BuildRequires:      python3-nose
%endif

%description
A "dogpile" lock, one which allows a single thread to generate an expensive
resource while other threads use the "old" value, until the "new" value is
ready.

Dogpile is basically the locking code extracted from the Beaker package,
for simple and generic usage.

%if 0%{?with_python3}
%package -n python3-dogpile-core
Summary:            A 'dogpile' lock, typically used as a component of a larger caching solution
Group:              Development/Libraries

%description -n python3-dogpile-core
A "dogpile" lock, one which allows a single thread to generate an expensive
resource while other threads use the "old" value, until the "new" value is
ready.

Dogpile is basically the locking code extracted from the Beaker package,
for simple and generic usage.
%endif

%prep
%setup -q -n %{modname}-%{version}

# Remove bundled egg-info in case it exists
rm -rf %{modname}.egg-info
%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif

%build
%{__python} setup.py build
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif


%install
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build --root=%{buildroot}
popd
%endif
%{__python} setup.py install -O1 --skip-build --root=%{buildroot}

%check
# Tests are not run since they take quite a while and appear to be sensitive to
# koji's environment.

%files
%doc README.rst LICENSE
%{python_sitelib}/dogpile/
%{python_sitelib}/%{modname}-%{version}*

%if 0%{?with_python3}
%files -n python3-dogpile-core
%doc README.rst LICENSE
%{python3_sitelib}/dogpile/
%{python3_sitelib}/%{modname}-%{version}-*
%endif

%changelog
* Tue Feb 11 2014 baseuser@ibm.com
- Base-f19.x spec file
