# enable systemd for Fedora-16 and RHEL-7
%if 0%{?fedora} > 15 || 0%{?rhel} > 6
    %bcond_without systemd
%else
    %bcond_with systemd
%endif

# install init scripts to /usr/libexec with systemd
%if %{with systemd}
    %define script_path %{_libexecdir}/iptables
%else
    %define script_path /etc/rc.d/init.d
%endif

# service legacy actions (RHBZ#748134)
%define legacy_actions %{_libexecdir}/initscripts/legacy-actions

# default service
%if 0%{?fedora} < 18 && 0%{?rhel} < 7
    %bcond_without default_service
%else
    %bcond_with default_service
%endif

Name: iptables
Summary: Tools for managing Linux kernel packet filtering capabilities
Version: 1.4.18
%define base_release .3
Release: 1%{?dist}%{?base_release}
Source: http://www.netfilter.org/projects/iptables/files/%{name}-%{version}.tar.bz2
Source1: iptables.init
Source2: iptables-config
Source3: iptables.service
Source4: iptables.save-legacy
Source999: fivextra.tar.bz2
Group: System Environment/Base
URL: http://www.netfilter.org/
BuildRoot: %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
License: GPLv2
# libnfnetlink-devel is requires for nfnl_osf
BuildRequires: libnfnetlink-devel
BuildRequires: libselinux-devel
BuildRequires: kernel-headers
Conflicts: kernel < 2.4.20
%if %{with systemd}
BuildRequires: systemd-units
%endif

# Virtually provide libxtables.so.9 to be able to create the buildroot.
# The iproute package is needed by iniscripts. iproute also provides tc, which
# requires libxtables.
%if %{_lib} == lib64
Provides: libxtables.so.9()(64bit)
%else
Provides: libxtables.so.9
%endif


%description
The iptables utility controls the network packet filtering code in the
Linux kernel. If you need to set up firewalls and/or IP masquerading,
you should install this package.

%package devel
Summary: Development package for iptables
Group: System Environment/Base
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig

%description devel
iptables development headers and libraries.

The iptc interface is upstream marked as not public. The interface is not 
stable and may change with every new version. It is therefore unsupported.

%package services
Summary: iptables and ip6tables services for iptables
Group: System Environment/Base
Requires: %{name} = %{version}-%{release}
%if %{with systemd}
Requires(post): systemd-units
Requires(post): systemd-sysv
Requires(preun): systemd-units
Requires(postun): systemd-units
Conflicts: systemd < 38
Conflicts: filesystem < 3
%else
Requires(post): chkconfig
Requires(preun): chkconfig
%endif
# provide and obsolete old main package
Provides: %{name} = 1.4.16.1
Obsoletes: %{name} <= 1.4.16.1
# provide and obsolte ipv6 sub package
Provides: %{name}-ipv6 = 1.4.11.1
Obsoletes: %{name}-ipv6 <= 1.4.11.1

%description services
iptables services for IPv4 and IPv6

This package provides the services iptables and ip6tables that have been split
out of the base package since they are not active by default anymore.

%package utils
Summary: iptables and ip6tables services for iptables
Group: System Environment/Base
Requires: %{name} = %{version}-%{release}

%description utils
Utils for iptables.

Currently only provides nfnl_osf with the pf.os database.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -a 999

%build
export CC=%{__cc}
CFLAGS="$RPM_OPT_FLAGS -fno-strict-aliasing " \
./configure --enable-devel --bindir=%{_bindir} --sbindir=%{_sbindir} --sysconfdir=/etc --libdir=%{_libdir} --libexecdir=%{_libdir} --mandir=%{_mandir} --includedir=%{_includedir} --datadir=%{_datadir}  --with-kernel=/usr --with-kbuild=/usr --with-ksource=/usr %{?cross_build:--target=%{_host} --host=%{_host} --build=%{_build_platform}}

# do not use rpath
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool

rm -f include/linux/types.h

make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
rm -rf %{buildroot}

make install DESTDIR=%{buildroot} 
# remove la file(s)
rm -f %{buildroot}/%{_libdir}/*.la

# install ip*tables.h header files
install -m 644 include/ip*tables.h %{buildroot}%{_includedir}/
install -d -m 755 %{buildroot}%{_includedir}/iptables
install -m 644 include/iptables/internal.h %{buildroot}%{_includedir}/iptables/

# install ipulog header file
install -d -m 755 %{buildroot}%{_includedir}/libipulog/
install -m 644 include/libipulog/*.h %{buildroot}%{_includedir}/libipulog/

# install init scripts and configuration files
install -d -m 755 %{buildroot}%{script_path}
install -c -m 755 %{SOURCE1} %{buildroot}%{script_path}/iptables.init
sed -e 's;iptables;ip6tables;g' -e 's;IPTABLES;IP6TABLES;g' < %{SOURCE1} > ip6tables.init
install -c -m 755 ip6tables.init %{buildroot}%{script_path}/ip6tables.init
install -d -m 755 %{buildroot}/etc/sysconfig
install -c -m 755 %{SOURCE2} %{buildroot}/etc/sysconfig/iptables-config
sed -e 's;iptables;ip6tables;g' -e 's;IPTABLES;IP6TABLES;g' < %{SOURCE2} > ip6tables-config
install -c -m 755 ip6tables-config %{buildroot}/etc/sysconfig/ip6tables-config

%if %{with systemd}
# install systemd service files
install -d -m 755 %{buildroot}/%{_unitdir}
install -c -m 644 %{SOURCE3} %{buildroot}/%{_unitdir}
sed -e 's;iptables;ip6tables;g' -e 's;IPv4;IPv6;g' -e 's;/usr/libexec/ip6tables;/usr/libexec/iptables;g' < %{SOURCE3} > ip6tables.service
install -c -m 644 ip6tables.service %{buildroot}/%{_unitdir}
%endif

# install legacy actions for service command
install -d %{buildroot}/%{legacy_actions}/iptables
install -d %{buildroot}/%{legacy_actions}/ip6tables
install -c -m 755 %{SOURCE4} %{buildroot}/%{legacy_actions}/iptables/save
sed -e 's;iptables.init;ip6tables.init;g' -e 's;IPTABLES;IP6TABLES;g' < %{buildroot}/%{legacy_actions}/iptables/save > ip6tabes.save-legacy
install -c -m 755 ip6tabes.save-legacy %{buildroot}/%{legacy_actions}/ip6tables/save

# Steps to package the iptables tests for FIV
cd %{_builddir}/%{name}-%{version}
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf %{buildroot}

%if %{with systemd}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post services
if [ $1 -eq 1 ] ; then # Initial installation
   /bin/systemctl daemon-reload >/dev/null 2>&1 || :
%if %{with default_service}
   /bin/systemctl enable iptables.service >/dev/null 2>&1 || :
   /bin/systemctl enable ip6tables.service >/dev/null 2>&1 || :
%endif
fi

%preun services
if [ $1 -eq 0 ]; then # Package removal, not upgrade
   /bin/systemctl --no-reload disable iptables.service > /dev/null 2>&1 || :
   /bin/systemctl --no-reload disable ip6tables.service > /dev/null 2>&1 || :
   /bin/systemctl stop iptables.service > /dev/null 2>&1 || :
   /bin/systemctl stop ip6tables.service > /dev/null 2>&1 || :
fi

%postun services
/sbin/ldconfig
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
if [ $1 -ge 1 ] ; then # Package upgrade, not uninstall
   /bin/systemctl try-restart iptables.service >/dev/null 2>&1 || :
   /bin/systemctl try-restart ip6tables.service >/dev/null 2>&1 || :
fi

%triggerun -- iptables < 1.4.11.1-3
# To apply saved runlevel, use systemd-sysv-convert --apply iptables
%{_bindir}/systemd-sysv-convert --save iptables >/dev/null 2>&1 ||:

# Autostart
%if %{with default_service}
/bin/systemctl --no-reload enable iptables.service >/dev/null 2>&1 ||:
%endif

# Delete from sysv management, try to restart service
/sbin/chkconfig --del iptables >/dev/null 2>&1 || :
/bin/systemctl try-restart iptables.service >/dev/null 2>&1 || :

%triggerun -- iptables-ipv6 < 1.4.11.1-3
# To apply saved runlevel, use systemd-sysv-convert --apply iptables
%{_bindir}/systemd-sysv-convert --save ip6tables >/dev/null 2>&1 ||:

# Autostart
%if %{with default_service}
/bin/systemctl --no-reload enable ip6tables.service >/dev/null 2>&1 ||:
%endif

# Delete from sysv management, try to restart service
/sbin/chkconfig --del ip6tables >/dev/null 2>&1 || :
/bin/systemctl try-restart ip6tables.service >/dev/null 2>&1 || :

%else # no systemd

%post -p /sbin/ldconfig

%post services
/sbin/chkconfig --add iptables
/sbin/chkconfig --add ip6tables

%preun services
if [ $1 -eq 0 ]; then
   /sbin/chkconfig --del iptables
   /sbin/chkconfig --del ip6tables
fi

%postun -p /sbin/ldconfig

%endif # systemd


%files
%defattr(-,root,root)
%doc COPYING INSTALL INCOMPATIBILITIES
%config(noreplace) %attr(0600,root,root) /etc/sysconfig/iptables-config
%config(noreplace) %attr(0600,root,root) /etc/sysconfig/ip6tables-config
%{_sbindir}/iptables*
%{_sbindir}/ip6tables*
%{_sbindir}/xtables-multi
%{_bindir}/iptables-xml
%{_mandir}/man1/iptables-xml*
%{_mandir}/man8/iptables*
%{_mandir}/man8/ip6tables*
%dir %{_libdir}/xtables
%{_libdir}/xtables/libipt*
%{_libdir}/xtables/libip6t*
%{_libdir}/xtables/libxt*
%{_libdir}/libip*tc.so.*
%{_libdir}/libxtables.so.*

%files devel
%defattr(-,root,root)
%dir %{_includedir}/iptables
%{_includedir}/iptables/*.h
%{_includedir}/*.h
%dir %{_includedir}/libiptc
%{_includedir}/libiptc/*.h
%dir %{_includedir}/libipulog
%{_includedir}/libipulog/*.h
%{_libdir}/libip*tc.so
%{_libdir}/libxtables.so
%{_libdir}/pkgconfig/libiptc.pc
%{_libdir}/pkgconfig/libip4tc.pc
%{_libdir}/pkgconfig/libip6tc.pc
%{_libdir}/pkgconfig/xtables.pc

%files services
%attr(0755,root,root) %{script_path}/iptables.init
%attr(0755,root,root) %{script_path}/ip6tables.init
%if %{with systemd}
%dir %{script_path}
%{_unitdir}/iptables.service
%{_unitdir}/ip6tables.service
%endif
%dir %{legacy_actions}/iptables
%{legacy_actions}/iptables/save
%dir %{legacy_actions}/ip6tables
%{legacy_actions}/ip6tables/save

%files utils
%{_sbindir}/nfnl_osf
%dir %{_datadir}/xtables
%{_datadir}/xtables/pf.os

%files fivextra
%{prefix}

%changelog
* Tue Jun 18 2013 baseuser@ibm.com
- Base-8.x spec file
