---
layout: base-with-padding
title: Configuration Guide
subtitle: Full list of supported properties
permalink: /configuration-guide/
---

{% include title-band.html %}

# Configuration Options
This page describes all the available configuration options.

All options start with the prefix `dekorate`.
Each option can be:

- array
- primitive
- string
- enum value
- complex type

## Arrays
They can be referenced by index inside brackets as in java for example: `dekorate.kubernetes.labels[0]`.

## Complex object
Each property of the complex object can be specified, by expanding the property key.
For example lets assume the object `Probe` that looks like:

| Property              | Type   | Description | Default Value |
|-----------------------|--------|-------------|---------------|
| http-action-path      | String |             |               |
| exec-action           | String |             |               |
| tcp-socket-action     | String |             |               |
| grpc-action           | String |             |               |
| initial-delay-seconds | int    |             |             0 |
| period-seconds        | int    |             |            30 |
| timeout-seconds       | int    |             |            10 |


To reference the `http-action-aath` of the complex object `Probe` which is used to define the `readiness-probe` property of `Kubernetes`:

    dekorate.kubernetes.readiness-probe.http-action-path=/some/path

## Casing

Please note that the casings for these properties are:

- camel case
- kebab

For example both of `dekorate.kubernetes.initContainers` and `dekorate.kubernetes.init-containers` are supported.
This document uses kebab.

Below is a list of all the available options.
The document is structured as follows.

- [dekorate options](#dekorate-options)
- [kubernetes](#kubernetes)
  - [global types](#global-types)
  - [mounts and voulumes](#mounts-and-volumes)
- [openshift](#openshift)
- [knative](#knative)
- [helm](#helm)

## Dekorate options

| Property           | Type    | Description                                                                                                                                                                                                                                                                                        | Default Value |
|--------------------|---------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| input-path         | String  | The path to input manifests. If the path is specified and the manifests are found, they will be used as input to the generator process. In this case, the instead of generating resources from scratch, the existing will be used and will be decarated according to the annotation configuration. |               |
| output-path        | String  | The output path where the generated/decorated manifests will be stored.                                                                                                                                                                                                                            |               |
| verbose            | boolean | Flag to enable verbose logging.                                                                                                                                                                                                                                                                    | false         |
| properties-profile | String  | The properties profile to use.                                                                                                                                                                                                                                                                     |               |
| build              | boolean | Flag to enable build.                                                                                                                                                                                                                                                                              | false         |
| push               | boolean | Flag to enable push.                                                                                                                                                                                                                                                                               | false         |
| deploy             | boolean | Flag to enable deply.                                                                                                                                                                                                                                                                              | false         |

## Kubernetes

| Property                                            | Type                          | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Default Value         |
|-----------------------------------------------------|-------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------|
| dekorate.kubernetes.part-of                         | String                        | The name of the collection of componnet this component belongs to. This value will be use as: - docker image repo - labeling resources                                                                                                                                                                                                                                                                                                                                                                                         |                              |
| dekorate.kubernetes.name                            | String                        | The name of the application. This value will be used for naming Kubernetes resources like: - Deployment - Service and so on ... If no value is specified it will attempt to determine the name using the following rules: If its a maven/gradle project use the artifact id. Else if its a bazel project use the name. Else if the system property app.name is present it will be used. Else find the project root folder and use its name (root folder detection is done by moving to the parent folder until .git is found). |                              |
| dekorate.kubernetes.version                         | String                        | The version of the application. This value be used for things like: - The docker image tag. If no value specified it will attempt to determine the name using the following rules:                                                                                                                                                                                                                                                                                                                                             |                              |
| dekorate.kubernetes.deployment-kind                 | String                        | The kind of the deployment resource to use. Supported values are 'Deployment', 'StatefulSet', 'Job' and 'CronJob' defaulting to the first.                                                                                                                                                                                                                                                                                                                                             | Deployment                             |
| dekorate.kubernetes.init-containers                 | Container[]                   | The init containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                              |
| dekorate.kubernetes.labels                          | Label[]                       | Custom labels to add to all resources.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                              |
| dekorate.kubernetes.annotations                     | Annotation[]                  | Custom annotations to add to all resources.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                              |
| dekorate.kubernetes.env-vars                        | Env[]                         | Environment variables to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                              |
| dekorate.kubernetes.working-dir                     | String                        | Working directory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                              |
| dekorate.kubernetes.command                         | String[]                      | The commands                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                              |
| dekorate.kubernetes.arguments                       | String[]                      | The arguments                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                              |
| dekorate.kubernetes.replicas                        | int                           | The number of replicas to use.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 1                            |
| dekorate.kubernetes.deployment-strategy             | DeploymentStrategy            | Specifies the deployment strategy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | None                         |
| dekorate.kubernetes.rolling-update                  | RollingUpdate                 | Specifies rolling update configuration. The configuration is applied when DeploymentStrategy == Rolling update, or when explicit configuration has been provided. In the later case RollingUpdate is assumed.                                                                                                                                                                                                                                                                                                                  | ( see RollingUpdate )        |
| dekorate.kubernetes.service-account                 | String                        | The service account.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                              |
| dekorate.kubernetes.ingress.expose                          | boolean                       | Controls whether the application should be exposed via Ingress                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | false                        |
| dekorate.kubernetes.ingress.host                            | String                        | The host under which the application is going to be exposed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                              |
| dekorate.kubernetes.ports                           | Port[]                        | The application ports.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                              |
| dekorate.kubernetes.service-type                    | ServiceType                   | The type of service that will be generated for the application.                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ClusterIP                    |
| dekorate.kubernetes.pvc-volumes                     | PersistentVolumeClaimVolume[] | PersistentVolumeClaim volumes to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                              |
| dekorate.kubernetes.secret-volumes                  | SecretVolume[]                | Secret volumes to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                              |
| dekorate.kubernetes.config-map-volumes              | ConfigMapVolume[]             | ConfigMap volumes to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                              |
| dekorate.kubernetes.empty-dir-volumes               | EmptyDirVolume[]              | EmptyDir volumes to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                              |
| dekorate.kubernetes.git-repo-volumes                | GitRepoVolume[]               | Git repo volumes to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                              |
| dekorate.kubernetes.aws-elastic-block-store-volumes | AwsElasticBlockStoreVolume[]  | Aws elastic block store volumes to add to all containers                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                              |
| dekorate.kubernetes.azure-disk-volumes              | AzureDiskVolume[]             | Azure disk volumes to add                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                              |
| dekorate.kubernetes.azure-file-volumes              | AzureFileVolume[]             | Azure file volumes to add                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                              |
| dekorate.kubernetes.mounts                          | Mount[]                       | Mounts to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                              |
| dekorate.kubernetes.image-pull-policy               | ImagePullPolicy               | Image pull policy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | IfNotPresent                 |
| dekorate.kubernetes.image-pull-secrets              | String[]                      | The image pull secret                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                              |
| dekorate.kubernetes.liveness-probe                  | Probe                         | The liveness probe.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | ( see Probe )                |
| dekorate.kubernetes.readiness-probe                 | Probe                         | The readiness probe.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ( see Probe )                |
| dekorate.kubernetes.request-resources               | ResourceRequirements          | The resources that the application container requires.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ( see ResourceRequirements ) |
| dekorate.kubernetes.limit-resources                 | ResourceRequirements          | The resource limit for the application container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ( see ResourceRequirements ) |
| dekorate.kubernetes.sidecars                        | Container[]                   | The sidecars.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                              |
| dekorate.kubernetes.ingress                         | Ingress                       | Configure the ingress resource. Only if the `expose` property is enabled.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | (See Ingress)                        |
| dekorate.kubernetes.headless                        | boolean                       | Controls whether the generated {@link Service} will be headless.                                                                                                                                                                                                                                                                                                                                                                                                                                                               | false                        |
| dekorate.kubernetes.auto-deploy-enabled             | boolean                       | Flag to trigger the registration of the deploy hook. It's generally preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here.                                                                                                                                                                                                                                                                                                                                                                                | false                        |
| dekorate.kubernetes.jobs                            | Job[]                         | The kubernetes jobs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | ( see Job )           |
| dekorate.kubernetes.cron-jobs                       | CronJob[]                     | The kubernetes cronJobs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | ( see CronJob )           |

### Minikube

| Property                                              | Type                            | Description                                                       | Default Value                                          |
|-- --------------------------------------------------- | ------------------------------- | ----------------------------------------------------------------- | -----------------------                                |
| dekorate.minikube.ports                               | Port[]                          | The application ports.                                            | {}                                                     |
| dekorate.minikube.service-type                        | ServiceType                     | The type of service that will be generated for the application.   | io.dekorate.kubernetes.annotation.ServiceType.NodePort |


### Global Types
The section below describes all the available subtypes.

#### Label

| Property | Type   | Description | Default Value |
|----------|--------|-------------|---------------|
| key      | String |             |               |
| value    | String |             |               |

#### Annotation

| Property | Type   | Description | Default Value |
|----------|--------|-------------|---------------|
| key      | String |             |               |
| value    | String |             |               |


#### Env

| Property  | Type   | Description                                                                                                                                                                                                                                                                 | Default Value |
|-----------|--------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| name      | String | The name of the environment variable.                                                                                                                                                                                                                                       |               |
| value     | String | The value of the environment variable. When no other fields are used (just name/value), this value will be assigned to the environment variable. If used with other fields, like secret, configmap, or field, it will indicate the key from with the value should be drawn. |               |
| secret    | String |                                                                                                                                                                                                                                                                             |               |
| configmap | String |                                                                                                                                                                                                                                                                             |               |
| field     | String |                                                                                                                                                                                                                                                                             |               |

#### Port

| Property       | Type     | Description                                                                                              | Default Value |
|----------------|----------|----------------------------------------------------------------------------------------------------------|---------------|
| name           | String   | The container port name.                                                                                 |               |
| container-port | int      | The port number. Refers to the container port.                                                           |               |
| host-port      | int      | The host port. When a host port is not specified (or is set  to 0) then the container port will be used. | 0             |
| path           | String   | The application path (refers to web application path).                                                   | /             |
| protocol       | Protocol |                                                                                                          | TCP           |

#### Container

| Property          | Type            | Description                                     | Default Value |
|-------------------|-----------------|-------------------------------------------------|---------------|
| image             | String          | The container image.                            |               |
| name              | String          | The container name.                             |               |
| env-vars          | Env[]           | Environment variables to add to all containers. |               |
| working-dir       | String          | Working directory.                              |               |
| command           | String[]        | The commands                                    |               |
| arguments         | String[]        | The arguments                                   |               |
| ports             | Port[]          | The application ports.                          |               |
| mounts            | Mount[]         | Mounts to add to all containers.                |               |
| image-pull-policy | ImagePullPolicy | Image pull policy.                              | IfNotPresent  |
| liveness-probe    | Probe           | The liveness probe.                             | ( see Probe ) |
| readiness-probe   | Probe           | The readiness probe.                            | ( see Probe ) |

#### Probe

| Property          | Type            | Description                                     | Default Value |
|-------------------|-----------------|-------------------------------------------------|---------------|
| http-action-path      | String | The http path to use for the probe For this to work, the container port also needs to be set Assuming the container port has been set (as per above comment), if execAction or tcpSocketAction are not set, an http probe will be used automatically even if no path is set (which will result in the root path being used) |               |
| exec-action           | String | The command to use for the probe.                                                                                                                                                                                                                                                                                           |               |
| tcp-socket-action     | String | The tcp socket to use for the probe (the format is host:port).                                                                                                                                                                                                                                                              |               |
| grpc-action           | String | The gRPC port to use for the probe (the format is either port or port:service).                                                                                                                                                                                                                                             |               |
| initial-delay-seconds | int    | The amount of time to wait in seconds before starting to probe.                                                                                                                                                                                                                                                             |             0 |
| period-seconds        | int    | The period in which the action should be called.                                                                                                                                                                                                                                                                            |            30 |
| timeout-seconds       | int    | The amount of time to wait for each action.                                                                                                                                                                                                                                                                                 |            10 |
| success-threshold     | int    | The success threshold to use.                                                                                                                                                                                                                                                                                               |             1 |
| failure-threshold     | int    | The failure threshold to use.                                                                                                                                                                                                                                                                                               |             3 |

#### Ingress

| Property           | Type     | Description                                             | Default Value |
|--------------------|----------|---------------------------------------------------------|---------------|
| tlsSecretName      | String   | The name of the secret used to configure TLS            |               |
| tlsHosts           | String[] | The list of hosts to be included in the TLS certificate | The application host  |

#### Jobs

| Property              | Type   | Description                                                                                                                                                                                                                                                                                                                 | Default Value |
|-----------------------|---------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| name                  | String  | The job name.                                                                                     |               |
| parallelism           | int     | Specifies the maximum desired number of pods the job should run at any given time.                |               |
| completions           | int     | Specifies the desired number of successfully finished pods the job should be run with.            |               |
| completionMode        | String  | CompletionMode specifies how Pod completions are tracked. Options: NonIndexed, Indexed.           |    NonIndexed |
| backoffLimit          | int     | Specifies the number of retries before marking this job failed.                                   |               |
| activeDeadlineSeconds | long    | Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive number.                                       |               |
| ttlSecondsAfterFinished    | int    | Limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted.    |               |
| suspend               | boolean | Suspend specifies whether the Job controller should create Pods or not.                           |         false |
| restartPolicy         | String  | Restart policy when the job container fails. Options: OnFailure, Never                            |     OnFailure |
| containers            | Container[]  | The containers to be run within the Job execution.                                           |  ( see Container ) |
| pvc-volumes           | PersistentVolumeClaimVolume[] | PersistentVolumeClaim volumes to add to all containers.                     |                    |
| secret-volumes        | SecretVolume[] | Secret volumes to add to all containers.                                                   |                    |
| config-map-volumes    | ConfigMapVolume[] | ConfigMap volumes to add to all containers.                                             |                    |
| empty-dir-volumes     | EmptyDirVolume[]  | EmptyDir volumes to add to all containers.                                              |                    |
| aws-elastic-block-store-volumes    | AwsElasticBlockStoreVolume[] | Aws elastic block store volumes to add to all containers.       |                    |
| azure-disk-volumes    | AzureDiskVolume[] | Azure disk volumes to add.                                                              |                    |
| azure-file-volumes    | AzureFileVolume[] | Azure file volumes to add.                                                              |                    |

#### CronJobs

| Property              | Type   | Description                                                                                                                                                                                                                                                                                                                 | Default Value |
|-----------------------|---------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| name                  | String  | The cron job name.                                                                                     |               |
| schedule              | String  | The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.                                                                            |               |
| concurrency-policy    | String  | ConcurrencyPolicy describes how the job will be handled. | Allow        |
| starting-deadline-seconds           | int     | Deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.                |  |
| failed-jobs-history-limit           | int     | The number of failed finished jobs to retain.                | 1  |
| successful-jobs-history-limit       | int     | The number of successful finished jobs to retain.            | 3  |
| parallelism           | int     | Specifies the maximum desired number of pods the job should run at any given time.                |               |
| completions           | int     | Specifies the desired number of successfully finished pods the job should be run with.            |               |
| completionMode        | String  | CompletionMode specifies how Pod completions are tracked. Options: NonIndexed, Indexed.           |    NonIndexed |
| backoffLimit          | int     | Specifies the number of retries before marking this job failed.                                   |               |
| activeDeadlineSeconds | long    | Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive number.                                       |               |
| ttlSecondsAfterFinished    | int    | Limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted.    |               |
| suspend               | boolean | Suspend specifies whether the Job controller should create Pods or not.                           |         false |
| restartPolicy         | String  | Restart policy when the job container fails. Options: OnFailure, Never                            |     OnFailure |
| containers            | Container[]  | The containers to be run within the Job execution.                                           |  ( see Container ) |
| pvc-volumes           | PersistentVolumeClaimVolume[] | PersistentVolumeClaim volumes to add to all containers.                     |                    |
| secret-volumes        | SecretVolume[] | Secret volumes to add to all containers.                                                   |                    |
| config-map-volumes    | ConfigMapVolume[] | ConfigMap volumes to add to all containers.                                             |                    |
| empty-dir-volumes     | EmptyDirVolume[]  | EmptyDir volumes to add to all containers.                                              |                    |
| aws-elastic-block-store-volumes    | AwsElasticBlockStoreVolume[] | Aws elastic block store volumes to add to all containers.       |                    |
| azure-disk-volumes    | AzureDiskVolume[] | Azure disk volumes to add.                                                              |                    |
| azure-file-volumes    | AzureFileVolume[] | Azure file volumes to add.                                                              |                    |

### Mounts and Volumes
#### Mount

| Property  | Type    | Description                                                                         | Default Value |
|-----------|---------|-------------------------------------------------------------------------------------|---------------|
| name      | String  | The name of the volumeName to mount.                                                |               |
| path      | String  | The path to mount.                                                                  |               |
| sub-path  | String  | Path within the volumeName from which the container's volumeName should be mounted. |               |
| read-only | boolean | ReadOnly                                                                            | false         |

#### ConfigMapVolume

| Property        | Type    | Description                            | Default Value |
|-----------------|---------|----------------------------------------|---------------|
| volume-name     | String  | The volumeName name.                   |               |
| config-map-name | String  | The name of the config map to mount.   |               |
| default-mode    | int     | Default mode.                          | 384           |
| optional        | boolean | Optional                               | false         |
| items           | Item[]  | List of files to be mounted. Optional. |               |

#### SecretVolume

| Property     | Type    | Description                             | Default Value |
|--------------|---------|-----------------------------------------|---------------|
| volume-name  | String  | The volumeName name.                    |               |
| secret-name  | String  | The name of the secret to mount.        |               |
| default-mode | int     | Default mode.                           | 384           |
| optional     | boolean | Optional                                | false         |
| items        | Item[]  | List of files to be mounted. Optional.  |               |

#### EmptyDirVolume

| Property        | Type    | Description                            | Default Value |
|-----------------|---------|----------------------------------------|---------------|
| volume-name     | String  | The volumeName name.                   |               |

#### PersistentVolumeClaimVolume

| Property    | Type    | Description                                | Default Value |
|-------------|---------|--------------------------------------------|---------------|
| volume-name | String  | The volumeName name.                       |               |
| claim-name  | String  | The persistent volumeName claim name.      |               |
| read-only   | boolean | Wether the volumeName is read only or not. | false         |

#### GitRepoVolume

| Property    | Type   | Description                               | Default Value |
|-------------|--------|-------------------------------------------|---------------|
| volume-name | String | The volumeName name.                      |               |
| repository  | String | Git repoistory URL.                       |               |
| directory   | String | The directory of the repository to mount. |               |
| revision    | String | The commit hash to use.                   |               |

#### AwsElasticBlockStoreVolume

| Property    | Type    | Description                                | Default Value |
|-------------|---------|--------------------------------------------|---------------|
| volume-name | String  | The volumeName name.                       |               |
| volume-id   | String  | The name of the disk to mount.             |               |
| partition   | int     |                                            |               |
| fs-type     | String  |                                            | ext4          |
| read-only   | boolean | Wether the volumeName is read only or not. | false         |

#### AzureDiskVolume

| Property    | Type    | Description | Default Value |
|-------------|---------|-------------|---------------|
| volume-name | String  |             |               |
| share-name  | String  |             |               |
| secret-name | String  |             |               |
| read-only   | boolean |             | false         |

#### AzureDiskVolume

| Property     | Type    | Description | Default Value |
|--------------|---------|-------------|---------------|
| volume-name  | String  |             |               |
| disk-name    | String  |             |               |
| disk-u-r-i   | String  |             |               |
| kind         | String  |             | Managed       |
| caching-mode | String  |             | ReadWrite     |
| fs-type      | String  |             | ext4          |
| read-only    | boolean |             | false         |

#### Item

| Property     | Type    | Description                                                        | Default Value |
|--------------|---------|--------------------------------------------------------------------|---------------|
| key          | String  | The key name within the data section (in Secrets and ConfigMaps).  |               |
| path         | String  | The path where the file will be mounted.                           |               |
| mode         | int     | File mode. If not specified, the volume defaultMode will be used.  |               |

## Generator Options

| Property    | Type   | Description                                                                                                                                                                                                                                                                                        | Default Value |
|-------------|--------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| input-path  | String | The path to input manifests. If the path is specified and the manifests are found, they will be used as input to the generator process. In this case, the instead of generating resources from scratch, the existing will be used and will be decarated according to the annotation configuration. |               |
| output-path | String | The output path where the generated/decorated manifests will be stored.                                                                                                                                                                                                                            |               |

## JvmOptions

| Property                         | Type               | Description                                                                                                        | Default Value |
|----------------------------------|--------------------|--------------------------------------------------------------------------------------------------------------------|---------------|
| xms                              | int                | Starting heap size in megabytes.                                                                                   | 0             |
| xmx                              | int                | Maxium heap size in megabytes.                                                                                     | 0             |
| server                           | boolean            | Server Flag.                                                                                                       | false         |
| use-string-deduplication         | boolean            | String deduplication flag.                                                                                         | false         |
| prefer-i-pv4-stack               | boolean            | Prefer IPv4 stack.                                                                                                 | false         |
| heap-dump-on-out-of-memory-error | boolean            | Instructs the JVM to dump heap into physical file in case of OutOfMemoryError                                      | false         |
| use-g-c-overhead-limit           | boolean            | Is a policy that limits the proportion of the VM’s time that is spent in GC before an OutOfMemory error is thrown. | false         |
| gc                               | GarbageCollector   | Garbage Collector implementation.                                                                                  | Undefined     |
| secure-random                    | SecureRandomSource | The Secure random source to use. This will determine -Djava.security.egd option.                                   | Undefined     |


## Docker

| Property                            | Type    | Description                                                                                                                                     | Default Value |
|-------------------------------------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| dekorate.docker.enabled             | boolean |                                                                                                                                                 | true          |
| dekorate.docker.registry            | String  | The registry that holds the image.                                                                                                              |               |
| dekorate.docker.group               | String  | The group of the application. This value will be use as image user.                                                                             |               |
| dekorate.docker.name                | String  | The name of the application. This value will be used as name.                                                                                   |               |
| dekorate.docker.version             | String  | The version of the application. This value be used as image tag.                                                                                |               |
| dekorate.docker.image               | String  | The name of the image to be generated. This property overrides group, name and version.                                                         |               |
| dekorate.docker.docker-file         | String  | The relative path of the Dockerfile, from the module root.                                                                                      | Dockerfile    |
| dekorate.docker.auto-push-enabled   | boolean | Flag to automatically push the image, to the specified registry.                                                                                | false         |
| dekorate.docker.auto-build-enabled  | boolean | Flag to automatically register a build hook after compilation.                                                                                  | false         |
| dekorate.docker.auto-deploy-enabled | boolean | Flag to trigger the registration of the deploy hook. It's generally preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here. | false         |

## Jib

| Property                         | Type    | Description                                                                                                                                     | Default Value |
|----------------------------------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| dekorate.jib.enabled             | boolean |                                                                                                                                                 | true          |
| dekorate.jib.registry            | String  | The registry that holds the image.                                                                                                              |               |
| dekorate.jib.group               | String  | The group of the application. This value will be use as image user.                                                                             |               |
| dekorate.jib.name                | String  | The name of the application. This value will be used as name.                                                                                   |               |
| dekorate.jib.version             | String  | The version of the application. This value be used as image tag.                                                                                |               |
| dekorate.jib.image               | String  |                                                                                                                                                 |               |
| dekorate.jib.image               | String  | The name of the image to be generated. This property overrides group, name and version.                                                         |               |
| dekorate.jib.docker-build        | boolean | Flag that indicates whether to perform a docker build (build using the docker daemon) or not.                                                   | true          |
| dekorate.jib.from                | String  | The base image to use.                                                                                                                          | openjdk:8-jdk |
| dekorate.jib.auto-push-enabled   | boolean | Flag to automatically push the image, to the specified registry.                                                                                | false         |
| dekorate.jib.auto-build-enabled  | boolean | Flag to automatically register a build hook after compilation.                                                                                  | false         |
| dekorate.jib.auto-deploy-enabled | boolean | Flag to trigger the registration of the deploy hook. It's generally preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here. | false         |

## Openshift

| Property                                           | Type                          | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Default Value |
|----------------------------------------------------|-------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| dekorate.openshift.part-of                         | String                        | The name of the collection of componnet this component belongs to. This value will be use as: - labeling resources                                                                                                                                                                                                                                                                                                                                                                                                             |                              |
| dekorate.openshift.name                            | String                        | The name of the application. This value will be used for naming Kubernetes resources like: - Deployment - Service and so on ... If no value is specified it will attempt to determine the name using the following rules: If its a maven/gradle project use the artifact id. Else if its a bazel project use the name. Else if the system property app.name is present it will be used. Else find the project root folder and use its name (root folder detection is done by moving to the parent folder until .git is found). |                              |
| dekorate.openshift.version                         | String                        | The version of the application. This value be used for things like: - The docker image tag. If no value specified it will attempt to determine the name using the following rules:                                                                                                                                                                                                                                                                                                                                             |                              |
| dekorate.openshift.deployment-kind                 | String                        | The kind of the deployment resource to use. Supported values are 'DeploymentConfig', 'Deployment', 'StatefulSet', 'Job' and 'CronJob' defaulting to the first.                                                                                                                                                                                                                                                                                                                                             | DeploymentConfig                             |
| dekorate.openshift.init-containers                 | Container[]                   | The init containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                              |
| dekorate.openshift.labels                          | Label[]                       | Custom labels to add to all resources.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                              |
| dekorate.openshift.annotations                     | Annotation[]                  | Custom annotations to add to all resources.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                              |
| dekorate.openshift.env-vars                        | Env[]                         | Environment variables to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                              |
| dekorate.openshift.working-dir                     | String                        | Working directory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                              |
| dekorate.openshift.command                         | String[]                      | The commands                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                              |
| dekorate.openshift.arguments                       | String[]                      | The arguments                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                              |
| dekorate.openshift.replicas                        | int                           | The number of replicas to use.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 1                            |
| dekorate.openshift.service-account                 | String                        | The service account.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                              |
| dekorate.openshift.host                            | String                        | The host under which the application is going to be exposed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                              |
| dekorate.openshift.ports                           | Port[]                        | The application ports.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                              |
| dekorate.openshift.service-type                    | ServiceType                   | The type of service that will be generated for the application.                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ClusterIP                    |
| dekorate.openshift.pvc-volumes                     | PersistentVolumeClaimVolume[] | PersistentVolumeClaim volumues to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                              |
| dekorate.openshift.secret-volumes                  | SecretVolume[]                | Secret volumues to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                              |
| dekorate.openshift.config-map-volumes              | ConfigMapVolume[]             | ConfigMap volumues to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                              |
| dekorate.openshift.empty-dir-volumes               | EmptyDirVolume[]              | EmptyDir volumes to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                              |
| dekorate.openshift.git-repo-volumes                | GitRepoVolume[]               | Git repo volumues to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                              |
| dekorate.openshift.aws-elastic-block-store-volumes | AwsElasticBlockStoreVolume[]  | Aws elastic block store volumes to add to all containers                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                              |
| dekorate.openshift.azure-disk-volumes              | AzureDiskVolume[]             | Azure disk volumes to add                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                              |
| dekorate.openshift.azure-file-volumes              | AzureFileVolume[]             | Azure file volumes to add                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                              |
| dekorate.openshift.mounts                          | Mount[]                       | Mounts to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                              |
| dekorate.openshift.image-pull-policy               | ImagePullPolicy               | Image pull policy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | IfNotPresent                 |
| dekorate.openshift.image-pull-secrets              | String[]                      | The image pull secret                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                              |
| dekorate.openshift.liveness-probe                  | Probe                         | The liveness probe.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | ( see Probe )                |
| dekorate.openshift.readiness-probe                 | Probe                         | The readiness probe.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ( see Probe )                |
| dekorate.openshift.request-resources               | ResourceRequirements          | The resources that the application container requires.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ( see ResourceRequirements ) |
| dekorate.openshift.limit-resources                 | ResourceRequirements          | The resource limit for the application container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ( see ResourceRequirements ) |
| dekorate.openshift.sidecars                        | Container[]                   | The sidecars.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                              |
| dekorate.openshift.expose                          | boolean                       | Controls whether the application should be exposed via Route                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | false                        |
| dekorate.openshift.headless                        | boolean                       | Controls whether the generated {@link Service} will be headless.                                                                                                                                                                                                                                                                                                                                                                                                                                                               | false                        |
| dekorate.openshift.auto-deploy-enabled             | boolean                       | Flag to trigger the registration of the deploy hook. It's generally preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here.                                                                                                                                                                                                                                                                                                                                                                                | false                        |
| dekorate.openshift.jobs                            | Job[]                         | The openshift jobs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | ( see Job )                  |
| dekorate.openshift.cron-jobs                       | CronJob[]                     | The openshift cronJobs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | ( see CronJob )                  |

### S2i

| Property                         | Type    | Description                                                                                                                                     | Default Value        |
|----------------------------------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------|----------------------|
| dekorate.s2i.enabled             | boolean |                                                                                                                                                 | true                 |
| dekorate.s2i.registry            | String  | The registry that holds the image.                                                                                                              |                      |
| dekorate.s2i.group               | String  | The group of the application. This value will be use as image user.                                                                             |                      |
| dekorate.s2i.name                | String  | The name of the application. This value will be used as name.                                                                                   |                      |
| dekorate.s2i.version             | String  | The version of the application. This value be used as image tag.                                                                                |                      |
| dekorate.s2i.image               | String  |                                                                                                                                                 |                      |
| dekorate.s2i.image               | String  | The name of the image to be generated. This property overrides group, name and version.                                                         |                      |
| dekorate.s2i.docker-file         | String  | The relative path of the Dockerfile, from the module root.                                                                                      | Dockerfile           |
| dekorate.s2i.builder-image       | String  | The S2i builder image to use.                                                                                                                   | fabric8/s2i-java:2.3 |
| dekorate.s2i.build-env-vars      | Env[]   | Environment variables to use for the s2i build.                                                                                                 |                      |
| dekorate.s2i.auto-push-enabled   | boolean | Flag to automatically push the image, to the specified registry.                                                                                | false                |
| dekorate.s2i.auto-build-enabled  | boolean | Flag to automatically register a build hook after compilation.                                                                                  | false                |
| dekorate.s2i.auto-deploy-enabled | boolean | Flag to trigger the registration of the deploy hook. It's generally preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here. | false                |

## Knative

| Property                                         | Type                          | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Default Value        |
|--------------------------------------------------|-------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------|
| dekorate.knative.part-of                         | String                        | The name of the collection of componnet this component belongs to. This value will be use as: - labeling resources                                                                                                                                                                                                                                                                                                                                                                                                             |                              |
| dekorate.knative.name                            | String                        | The name of the application. This value will be used for naming Kubernetes resources like: - Deployment - Service and so on ... If no value is specified it will attempt to determine the name using the following rules: If its a maven/gradle project use the artifact id. Else if its a bazel project use the name. Else if the system property app.name is present it will be used. Else find the project root folder and use its name (root folder detection is done by moving to the parent folder until .git is found). |                              |
| dekorate.knative.version                         | String                        | The version of the application. This value be used for things like: - The docker image tag. If no value specified it will attempt to determine the name using the following rules:                                                                                                                                                                                                                                                                                                                                             |                              |
| dekorate.knative.labels                          | Label[]                       | Custom labels to add to all resources.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                              |
| dekorate.knative.annotations                     | Annotation[]                  | Custom annotations to add to all resources.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                              |
| dekorate.knative.env-vars                        | Env[]                         | Environment variables to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                              |
| dekorate.knative.working-dir                     | String                        | Working directory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                              |
| dekorate.knative.command                         | String[]                      | The commands                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                              |
| dekorate.knative.arguments                       | String[]                      | The arguments                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                              |
| dekorate.knative.service-account                 | String                        | The service account.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                              |
| dekorate.knative.host                            | String                        | The host under which the application is going to be exposed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                              |
| dekorate.knative.ports                           | Port[]                        | The application ports.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                              |
| dekorate.knative.http-transport-version          | HttpTransportVersion          | Http trasport version to use.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | HTTP1                        |
| dekorate.knative.service-type                    | ServiceType                   | The type of service that will be generated for the application.                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ClusterIP                    |
| dekorate.knative.pvc-volumes                     | PersistentVolumeClaimVolume[] | PersistentVolumeClaim volumues to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                              |
| dekorate.knative.secret-volumes                  | SecretVolume[]                | Secret volumues to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                              |
| dekorate.knative.config-map-volumes              | ConfigMapVolume[]             | ConfigMap volumues to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                              |
| dekorate.knative.empty-dir-volumes               | EmptyDirVolume[]              | EmptyDir volumes to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                              |
| dekorate.knative.git-repo-volumes                | GitRepoVolume[]               | Git repo volumues to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                              |
| dekorate.knative.aws-elastic-block-store-volumes | AwsElasticBlockStoreVolume[]  | Aws elastic block store volumes to add to all containers                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                              |
| dekorate.knative.azure-disk-volumes              | AzureDiskVolume[]             | Azure disk volumes to add                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                              |
| dekorate.knative.azure-file-volumes              | AzureFileVolume[]             | Azure file volumes to add                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                              |
| dekorate.knative.mounts                          | Mount[]                       | Mounts to add to all containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                              |
| dekorate.knative.image-pull-policy               | ImagePullPolicy               | Image pull policy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | IfNotPresent                 |
| dekorate.knative.image-pull-secrets              | String[]                      | The image pull secret                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                              |
| dekorate.knative.liveness-probe                  | Probe                         | The liveness probe.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | ( see Probe )                |
| dekorate.knative.readiness-probe                 | Probe                         | The readiness probe.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ( see Probe )                |
| dekorate.knative.request-resources               | ResourceRequirements          | The resources that the application container requires.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ( see ResourceRequirements ) |
| dekorate.knative.limit-resources                 | ResourceRequirements          | The resource limit for the application container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ( see ResourceRequirements ) |
| dekorate.knative.sidecars                        | Container[]                   | The sidecars.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                              |
| dekorate.knative.expose                          | boolean                       | Controls whether the application should be exposed (default: true). Services that are not exposed with be labeled as cluster local (see https://knative.dev/docs/serving/services/private-services).                                                                                                                                                                                                                                                                                                                                 | true                         |
| dekorate.knative.auto-deploy-enabled             | boolean                       | Flag to trigger the registration of the deploy hook. It's generally preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here.                                                                                                                                                                                                                                                                                                                                                                                | false                        |
| dekorate.knative.min-scale                       | int                           | This value controls the minimum number of replicas each revision should have. Knative will attempt to never have less than this number of replicas at any one point in time.                                                                                                                                                                                                                                                                                                                                                   | 0                            |
| dekorate.knative.max-scale                       | int                           | This value controls the maximum number of replicas each revision should have. Knative will attempt to never have more than this number of replicas running, or in the process of being created, at any one point in time.                                                                                                                                                                                                                                                                                                      | 0                            |
| dekorate.knative.scale-to-zero-enabled           | boolean                       | The scale-to-zero values control whether Knative allows revisions to scale down to zero, or stops at “1”.                                                                                                                                                                                                                                                                                                                                                                                                                      | true                         |
| dekorate.knative.revision-auto-scaling           | AutoScaling                   | Revision autoscaling configuration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | ( see concurrency) )         |
| dekorate.knative.global-auto-scaling             | GlobalAutoScaling             | Global autoscaling configuration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ( see kpa) )                 |
| dekorate.knative.jobs                            | Job[]                         | The kubernetes jobs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ( see Job )                  |
| dekorate.knative.cron-jobs                       | CronJob[]                         | The kubernetes cronJobs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ( see CronJob )                  |

## Helm

| Property                                         | Type                          | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Default Value        |
|--------------------------------------------------|-------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------|
| dekorate.helm.enabled                            | boolean                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | true                 |
| dekorate.helm.name                               | String                        | The Helm chart name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                      |
| dekorate.helm.alias                               | String                       | The root property name to map all the properties to the Values.yaml file.                                                                                                                                                                                                                                                                                                                                                                                                                                                      | app                 |
| dekorate.helm.description                        | String                        | The Helm chart single-sentence description.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                      |
| dekorate.helm.version                            | String                        | The Helm chart version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                      |
| dekorate.helm.icon                               | String                        | The Helm chart URL to an SVG or PNG image to be used as an icon.                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                      |
| dekorate.helm.home                               | String                        | The Helm chart URL for this project's home page.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                      |
| dekorate.helm.keywords                           | String[]                      | List of keywords to add to the chart.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                      |
| dekorate.helm.sources                            | String[]                      | The Helm chart list of URLs to source code for this project.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                      |
| dekorate.helm.createTarFile                          | boolean                        | Generates the Helm tarball file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | false               |
| dekorate.helm.extension                          | String                        | Extension of the Helm tarball file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | tar.gz               |
| dekorate.helm.maintainers                        | Maintainer[]                  | The Helm chart list of maintainers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                      |
| dekorate.helm.dependencies                       | HelmDependency[]              | The Helm chart list of dependencies.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                      |
| dekorate.helm.values                             | ValueReference[]              | The configuration references to be mapped into the Helm values file.                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                      |

### Maintainer

| Property  | Type    | Description                                                                         | Default Value |
|-----------|---------|-------------------------------------------------------------------------------------|---------------|
| name      | String  | The maintainer name.                                                                |               |
| email     | String  | The maintainer email.                                                               |               |
| url       | String  | The maintainer URL profile.                                                         |               |

### HelmDependency

| Property   | Type    | Description                                                                         | Default Value          |
|------------|---------|-------------------------------------------------------------------------------------|------------------------|
| name       | String  | The dependency name.                                                                |                        |
| version    | String  | The dependency version.                                                             |                        |
| repository | String  | The dependency repository.                                                          |                        |
| alias      | String  | Alias of the the dependency                                                         | The dependency name    |
| condition  | String  | (Optional) Condition to enable/disable the current Helm dependency.                 | The dependency name    |
| tags       | String[]| (Optional) Tags associated with the current Helm dependency                         |                        |

### ValueReference

| Property   | Type     | Description                                                                                                                                                                                | Default Value |
|------------|----------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| property   | String   | The name of the property in the Helm values file.                                                                                                                                          |               |
| paths  | String   | A comma-separated list of path expressions to map the Dekorate auto-generated properties to the final Helm values file.        |               |
| profile    | String   | The dependency repository.                                                                                                                                                                 | (empty)       |
| value      | String   | The dependency repository.                                                                                                                                                                 | (empty)       |
| expression | String   | The complete Helm expression to be replaced with. If not provided, it will use `{{ .Values.<root alias>.<property> }}`.                                                                    | (empty)       |

## Tekton

| Property                                        | Type                  | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Default Value                      |
|-------------------------------------------------|-----------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------|
| dekorate.tekton.part-of                         | String                | The name of the collection of component this component belongs to. This value will be use as: - labeling resources                                                                                                                                                                                                                                                                                                                                                                                                             |                                    |
| dekorate.tekton.name                            | String                | The name of the application. This value will be used for naming Kubernetes resources like: - Deployment - Service and so on ... If no value is specified it will attempt to determine the name using the following rules: If its a maven/gradle project use the artifact id. Else if its a bazel project use the name. Else if the system property app.name is present it will be used. Else find the project root folder and use its name (root folder detection is done by moving to the parent folder until .git is found). |                                    |
| dekorate.tekton.version                         | String                | The version of the application. This value be used for things like: - The docker image tag. If no value specified it will attempt to determine the name using the following rules:                                                                                                                                                                                                                                                                                                                                             |                                    |
| dekorate.tekton.labels                          | Label[]               | Custom labels to add to all resources.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                                    |
| dekorate.tekton.annotations                     | Annotation[]          | Custom annotations to add to all resources.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                                    |
| dekorate.tekton.external-git-pipeline-resource  | String                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                                    |
| dekorate.tekton.source-workspace                | String                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | source                             |
| dekorate.tekton.external-source-workspace-claim | String                | The name of an external PVC to be used for the source workspace.                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                                    |
| dekorate.tekton.source-workspace-claim          | PersistentVolumeClaim |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ( see PersistentVolumeClaim )      |
| dekorate.tekton.m2-workspace                    | String                | The name of workspace to use as a maven artifact repository.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | m2                                 |
| dekorate.tekton.external-m2-workspace-claim     | String                | The name of an external PVC to be used for the m2 artifact repository.                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                                    |
| dekorate.tekton.m2-workspace-claim              | PersistentVolumeClaim |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ( see PersistentVolumeClaim )      |
| dekorate.tekton.builder-image                   | String                | The builder image to use.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                                    |
| dekorate.tekton.builder-command                 | String                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                                    |
| dekorate.tekton.builder-arguments               | String[]              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                                    |
| dekorate.tekton.deployer-image                  | String                | The docker image to be used for the deployment task. Such image needs to have kubectl available.                                                                                                                                                                                                                                                                                                                                                                                                                               | lachlanevenson/k8s-kubectl:v1.18.0 |
| dekorate.tekton.image-push-service-account      | String                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                                    |
| dekorate.tekton.image-push-secret               | String                | The secret to use when generating an image push service account. When no existing service account is provided, one will be generated. The generated service account may or may not use an existing secret.                                                                                                                                                                                                                                                                                                                     |                                    |
| dekorate.tekton.use-local-docker-config-json    | boolean               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | false                              |
| dekorate.tekton.registry                        | String                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | docker.io                          |
| dekorate.tekton.registry-username               | String                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                                    |
| dekorate.tekton.registry-password               | String                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                                    |


## Prometheus

| Property     | Type    | Description| Default Value |
|--------------|---------|------------|---------------|
| port         | String  |            | "http"        |
| path         | String  |            | "/metrics"    |
| interval     | int     |            | 10            |
| honor-labels | boolean |            | false         |

## Jaeger

| Property         | Type      | Description                                                | Default Value     |
|------------------|-----------|------------------------------------------------------------|-------------------|
| operator-enabled | boolean   | Flag to specify if Jaeger operator is available / enabled. | false             |
| version          | String    | The jaeger agent version.                                  | "1.10"            |
| collector        | Collector |                                                            | ( see Collector ) |
| ports            | Port[]    |                                                            | {}                |

## ServiceBinding

| Property                 | Type        | Description         | Default Value                        |
|--------------------------|-------------|---------------------|--------------------------------------|
| name                     | String      |                     |  ""                                  |
| application              | Application |                     | ( see Application )                  |
| services                 | Service[]   |                     | {}                                   |
| env-var-prefix           | String      |                     | ""                                   |
| detect-binding-resources | boolean     |                     | false                                |
| bind-as-files            | boolean     |                     | false                                |
| mount-path               | String      |                     | ""                                   |
| custom-env-var           | Env[]       |                     | {}                                   |
| binding-path             | BindingPath |                     | ( see BindingPath )                  |

## Binding-path

| Property           | Type   | Description | Default Value |
|--------------------|--------|-------------|---------------|
| dekorate..resource | String | ""          |               |
| dekorate..kind     | String | ""          |               |
| dekorate..name     | String | ""          |               |
| dekorate..group    | String | ""          |               |
| dekorate..version  | String | ""          |               |

## Service

| Property       | Type   | Description | Default Value |
|----------------|--------|-------------|---------------|
| group          | String |             |               |
| kind           | String |             |               |
| name           | String | ""          |               |
| version        | String |             |               |
| id             | String | ""          |               |
| namespace      | String | ""          |               |
| env-var-prefix | String | ""          |               |


## BindingPath

| Property       | Type   | Description | Default Value |
|----------------|--------|-------------|---------------|
| container-path | String | ""          |               |
| secret-path    | String | ""          |               |  

## Cert-Manager

| Property                              | Type            | Description                                               | Default Value        |
|---------------------------------------|-----------------|-----------------------------------------------------------|----------------------|
| dekorate.certificate.name             | String          | Name of the certificate resource to be generated          | The application name |
| dekorate.certificate.secretName       | String          | the name of the secret resource                           |                      |  
| dekorate.certificate.issuerRef        | IssuerRef       | the reference to the issuer                               |                      |
| dekorate.certificate.ca               | CA              | the CA issuer configuration                               |                      |
| dekorate.certificate.vault            | Vault           | the Vault issuer configuration                            |                      |
| dekorate.certificate.selfSigned       | SelfSigned      | the SelfSigned issuer configuration                       |                      |
| dekorate.certificate.subject          | Subject         | the full X509 name specification                          |                      |
| dekorate.certificate.commonName       | String          | common name to be used on the Certificate                 |                      |  
| dekorate.certificate.duration         | String          | the lifetime of the Certificate                           |                      |  
| dekorate.certificate.renewBefore      | String          | the renewal before duration timestamp                     |                      |  
| dekorate.certificate.dnsNames         | String[]        | the list of [Subject Alternative Names](https://en.wikipedia.org/wiki/Subject_Alternative_Name). Find more information in [the Cert-Manager Dekorate](https://dekorate.io/docs/cert-manager#securing-resources) documentation.                           |                      |  
| dekorate.certificate.ipAddresses      | String[]        | the list of IP address subjectAltNames                    |                      |  
| dekorate.certificate.uris             | String[]        | the list of URI subjectAltNames                           |                      |  
| dekorate.certificate.emailAddresses   | String[]        | the list of email subjectAltNames                         |                      |  
| dekorate.certificate.keystores        | CertificateKeystores  | the Keystores generation configuration              |                      |  
| dekorate.certificate.isCA             | Boolean         | if true, it will mark this Certificate as valid for certificate signing  |       |  
| dekorate.certificate.usages           | String[]        | the set of x509 usages that are requested for the certificate            |       |
| dekorate.certificate.privateKey       | CertificatePrivateKey | options to control private keys used for the Certificate           |       |
| dekorate.certificate.encodeUsagesInRequest  | Boolean   | whether key usages should be present in the CertificateRequest           | false |
| dekorate.certificate.volumeMountPath  | String          | the mount path where the generated certificate resources will be mounted | /etc/certs |

### IssuerRef

| Property       | Type   | Description | Default Value |
|----------------|--------|-------------|---------------|
| name           | String |             |               |
| kind           | String |             |               |  
| group          | String |             |               |  

### CA

| Property               | Type     | Description | Default Value |
|------------------------|----------|-------------|---------------|
| secretName             | String   |             |               |
| crlDistributionPoints  | String[] |             |               | 

### Vault

| Property               | Type                   | Description | Default Value |
|------------------------|------------------------|-------------|---------------|
| server                 | String                 |             |               |
| path                   | String                 |             |               | 
| authTokenSecretRef     | LocalObjectReference   |             |               | 
| authAppRole            | VaultAppRole           |             |               | 
| authKubernetes         | VaultKubernetesAuth    |             |               | 
| namespace              | String                 |             |               |
| caBundle               | String                 |             |               | 

**Note**: Only one auth mechanism can be set among `authTokenSecretRef`, `authAppRole` and `authKubernetes`.

### SelfSigned

| Property               | Type     | Description | Default Value |
|------------------------|----------|-------------|---------------|
| enabled                | boolean  |             | false         |
| crlDistributionPoints  | String[] |             |               | 

### LocalObjectReference

| Property       | Type   | Description | Default Value |
|----------------|--------|-------------|---------------|
| name           | String |             |               |
| key            | String |             |               |  

### VaultAppRole

| Property       | Type                 | Description | Default Value |
|----------------|----------------------|-------------|---------------|
| path           | String               |             |               |
| roleId         | String               |             |               | 
| secretRef      | LocalObjectReference |             |               | 

### VaultKubernetesAuth

| Property       | Type                 | Description | Default Value |
|----------------|----------------------|-------------|---------------|
| mountPath      | String               |             |               |
| role           | String               |             |               | 
| secretRef      | LocalObjectReference |             |               | 

### Subject

| Property               | Type     | Description | Default Value |
|------------------------|----------|-------------|---------------|
| organizations          | String[] |             |               |
| countries              | String[] |             |               | 
| organizationalUnits    | String[] |             |               |
| localities             | String[] |             |               | 
| provinces              | String[] |             |               |
| streetAddresses        | String[] |             |               | 
| postalCodes            | String[] |             |               |
| serialNumber           | String   |             |               | 

### CertificateKeystores

| Property       | Type                 | Description                                                                      | Default Value |
|----------------|----------------------|----------------------------------------------------------------------------------|---------------|
| jks            | CertificateKeystore  | If set, a file named keystore.jks will be created in the target Secret resource  |               |
| pkcs12         | CertificateKeystore  | If set, a file named keystore.p12 will be created in the target Secret resource  |               | 

### CertificateKeystore

| Property           | Type                 | Description | Default Value |
|--------------------|----------------------|-------------|---------------|
| create             | boolean              |             | false         |
| passwordSecretRef  | LocalObjectReference |             |               | 

### CertificatePrivateKey

| Property       | Type   | Description | Default Value |
|----------------|--------|-------------|---------------|
| rotationPolicy | String |             |               |
| encoding       | String |             |               | 
| algorithm      | String |             |               | 
| size           | String |             |               | 
