/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.shrinkwrap.descriptor.api;

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptorImplBase;

/**
 * {@link TestDescriptor} implementation for use in testing
 *
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class TestDescriptorImpl extends NodeDescriptorImplBase implements TestDescriptor {

    /**
     * Root Node
     */
    private final Node root;

    /**
     * Creates a new instance w/ the specified name
     *
     * @param name
     */
    public TestDescriptorImpl(String descriptorName) {
        this(descriptorName, new Node("test"));
    }

    /**
     * Creates a new instance w/ the specified name and root node
     *
     * @param name
     * @param node
     */
    public TestDescriptorImpl(final String descriptorName, final Node node) {
        super(descriptorName);
        this.root = node;
    }

    /**
     * {@inheritDoc}
     *
     * @see org.jboss.shrinkwrap.descriptor.spi.NodeProvider#getRootNode()
     */
    @Override
    public Node getRootNode() {
        return root;
    }
}
