/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.dom.NodeWrapper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentWrapper
extends NodeWrapper
implements DocumentInfo {
    protected NamePool namePool;
    protected String baseURI;
    protected int documentNumber;

    public DocumentWrapper(Document document, String string) {
        super(document, null, 0);
        this.node = document;
        this.nodeKind = (short)9;
        this.baseURI = string;
        this.docWrapper = this;
        this.namePool = NamePool.getDefaultNamePool();
    }

    public NodeWrapper wrap(Node node) {
        if (node == this.docWrapper) {
            return this;
        }
        return this.makeWrapper(node, this);
    }

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
        this.documentNumber = namePool.allocateDocumentNumber(this);
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public NodeInfo selectID(String string) {
        Element element = ((Document)this.node).getElementById(string);
        if (element == null) {
            return null;
        }
        return this.wrap(element);
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof DocumentWrapper)) {
            return false;
        }
        return this.node == ((DocumentWrapper)nodeInfo).node;
    }

    public String[] getUnparsedEntity(String string) {
        return null;
    }
}

