/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;

public abstract class IClassLoader {
    private static final boolean DEBUG = false;
    public IClass OBJECT;
    public IClass STRING;
    public IClass CLASS;
    public IClass THROWABLE;
    public IClass RUNTIME_EXCEPTION;
    public IClass ERROR;
    public IClass CLONEABLE;
    public IClass SERIALIZABLE;
    public IClass BOOLEAN;
    public IClass BYTE;
    public IClass CHARACTER;
    public IClass SHORT;
    public IClass INTEGER;
    public IClass LONG;
    public IClass FLOAT;
    public IClass DOUBLE;
    private final IClassLoader optionalParentIClassLoader;
    private final Map loadedIClasses = new HashMap();
    private final Set unloadableIClasses = new HashSet();

    public IClassLoader(IClassLoader iClassLoader) {
        this.optionalParentIClassLoader = iClassLoader;
    }

    protected final void defineIClass(IClass iClass) {
        String string = iClass.getDescriptor();
        IClass iClass2 = (IClass)this.loadedIClasses.get(string);
        if (iClass2 != null) {
            if (iClass2 == iClass) {
                return;
            }
            throw new RuntimeException("Non-identical definition of IClass \"" + string + "\"");
        }
        this.loadedIClasses.put(string, iClass);
    }

    protected abstract IClass findIClass(String var1) throws ClassNotFoundException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final IClass loadIClass(String string) throws ClassNotFoundException {
        IClass iClass;
        if (Descriptor.isPrimitive(string)) {
            IClass iClass2;
            if (string.equals("V")) {
                iClass2 = IClass.VOID;
                return iClass2;
            } else if (string.equals("B")) {
                iClass2 = IClass.BYTE;
                return iClass2;
            } else if (string.equals("C")) {
                iClass2 = IClass.CHAR;
                return iClass2;
            } else if (string.equals("D")) {
                iClass2 = IClass.DOUBLE;
                return iClass2;
            } else if (string.equals("F")) {
                iClass2 = IClass.FLOAT;
                return iClass2;
            } else if (string.equals("I")) {
                iClass2 = IClass.INT;
                return iClass2;
            } else if (string.equals("J")) {
                iClass2 = IClass.LONG;
                return iClass2;
            } else if (string.equals("S")) {
                iClass2 = IClass.SHORT;
                return iClass2;
            } else {
                if (!string.equals("Z")) return null;
                iClass2 = IClass.BOOLEAN;
            }
            return iClass2;
        }
        if (this.optionalParentIClassLoader != null && (iClass = this.optionalParentIClassLoader.loadIClass(string)) != null) {
            return iClass;
        }
        IClassLoader iClassLoader = this;
        synchronized (iClassLoader) {
            if (this.unloadableIClasses.contains(string)) {
                return null;
            }
            iClass = (IClass)this.loadedIClasses.get(string);
            if (iClass != null) {
                return iClass;
            }
            if (Descriptor.isArrayReference(string)) {
                IClass iClass3 = this.loadIClass(Descriptor.getComponentDescriptor(string));
                if (iClass3 == null) {
                    return null;
                }
                IClass iClass4 = iClass3.getArrayIClass(this.OBJECT);
                this.loadedIClasses.put(string, iClass4);
                return iClass4;
            }
            iClass = this.findIClass(string);
            if (iClass == null) {
                this.unloadableIClasses.add(string);
                return null;
            }
        }
        if (iClass.getDescriptor().equalsIgnoreCase(string)) return iClass;
        throw new RuntimeException("\"findIClass()\" returned \"" + iClass.getDescriptor() + "\" instead of \"" + string + "\"");
    }

    protected final void postConstruct() {
        try {
            this.OBJECT = this.loadIClass("Ljava/lang/Object;");
            this.STRING = this.loadIClass("Ljava/lang/String;");
            this.CLASS = this.loadIClass("Ljava/lang/Class;");
            this.THROWABLE = this.loadIClass("Ljava/lang/Throwable;");
            this.RUNTIME_EXCEPTION = this.loadIClass("Ljava/lang/RuntimeException;");
            this.ERROR = this.loadIClass("Ljava/lang/Error;");
            this.CLONEABLE = this.loadIClass("Ljava/lang/Cloneable;");
            this.SERIALIZABLE = this.loadIClass("Ljava/io/Serializable;");
            this.BOOLEAN = this.loadIClass("Ljava/lang/Boolean;");
            this.BYTE = this.loadIClass("Ljava/lang/Byte;");
            this.CHARACTER = this.loadIClass("Ljava/lang/Character;");
            this.SHORT = this.loadIClass("Ljava/lang/Short;");
            this.INTEGER = this.loadIClass("Ljava/lang/Integer;");
            this.LONG = this.loadIClass("Ljava/lang/Long;");
            this.FLOAT = this.loadIClass("Ljava/lang/Float;");
            this.DOUBLE = this.loadIClass("Ljava/lang/Double;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Cannot load simple types");
        }
    }
}

