package aQute.service.library;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LibraryVersionRange {
	LibraryVersion high;
	LibraryVersion low;
	char start = '[';
	char end = ']';

	static Pattern RANGE = Pattern
			.compile(
					"(\\(|\\[)\\s*([-\\da-zA-Z._]+)\\s*,\\s*([-\\da-zA-Z._]+)\\s*(\\]|\\))",
					Pattern.DOTALL);

	public LibraryVersionRange(String string) {
		string = string.trim();
		Matcher m = RANGE.matcher(string);
		if (m.matches()) {
			low = new LibraryVersion(m.group(2));
			high = new LibraryVersion(m.group(3));
			start = m.group(1).charAt(0);
			end = m.group(4).charAt(0);
			if (low.compareTo(high) > 0)
				throw new IllegalArgumentException(
						"Low Range is higher than High Range: " + low + "-"
								+ high);
		} else
			high = low = new LibraryVersion(string);
	}

	public boolean isRange() {
		return high != low;
	}

	public boolean includeLow() {
		return start == '[';
	}

	public boolean includeHigh() {
		return end == ']';
	}

	@Override
	public String toString() {
		if (high == low)
			return high.toString();

		StringBuilder sb = new StringBuilder();
		sb.append(start);
		sb.append(low);
		sb.append(',');
		sb.append(high);
		sb.append(end);
		return sb.toString();
	}

	public LibraryVersion getLow() {
		return low;
	}

	public LibraryVersion getHigh() {
		return high;
	}

	public boolean includes(LibraryVersion v) {
		if (!isRange()) {
			return low.compareTo(v) <= 0;
		}
		if (includeLow()) {
			if (v.compareTo(low) < 0)
				return false;
		} else if (v.compareTo(low) <= 0)
			return false;

		if (includeHigh()) {
			if (v.compareTo(high) > 0)
				return false;
		} else if (v.compareTo(high) >= 0)
			return false;

		return true;
	}

	public List<LibraryVersion> filter(final Iterable<LibraryVersion> versions) {
		List<LibraryVersion> list = new ArrayList<LibraryVersion>();
		for (LibraryVersion v : versions) {
			if (includes(v))
				list.add(v);
		}
		return list;
	}

}
