#JBoss Unified Push Server
This archive contains a deployable JBoss Unified Push Server. Instructions are provided here for deploying the Unified Push Server to Red Hat JBoss Application Platform 6.3.

**Note:** You can also run the Unified Push Server in the cloud with OpenShift but this requires a different setup process; for instructions, see the [JBoss Unified Push documentation](https://access.redhat.com/documentation/en-US/Red_Hat_JBoss_Unified_Push/).

##Deploy the Unified Push Server
The Unified Push Server application is provided in two files: `unified-push-server.war` and `unified-push-auth-server.war`. These files contain the core functionality and authentication components of the Unified Push Server. Both files are necessary to achieve a working Unified Push Server application.

The Unified Push Server also requires an accompanying database in which to store push application, variant and installation details. To demonstrate the simplicity of deploying the Unified Push Server, instructions are provided here for using the embedded JBoss EAP H2 database and provided `unified-push-h2-ds.xml` file. Instructions for generating the H2 database from scratch or using alternative databases are given later.

**Warning:** The H2 data storage and direct deployment of `*-ds.xml` files can be used for development purposes but they are not supported for production use.

1. Copy the H2 datasource file to the JBoss EAP deployments directory
```shell
$ cp databases/unified-push-h2-ds.xml /path/to/jboss-eap/standalone/deployments/
```
2. Copy the Unified Push Server application files to the JBoss EAP deployments directory
```shell
$ cp unified-push-server.war unified-push-auth-server.war /path/to/jboss-eap/standalone/deployments/
```	
3. Start JBoss EAP
```shell
$ ./path/to/jboss-eap/bin/standalone.sh
```
**Note:** Adding "-b 0.0.0.0" to the above commands will allow external clients (phones, tablets, desktops, etc...) to connect through your local network:
```shell
$ ./path/to/jboss-eap/bin/standalone.sh -b 0.0.0.0
```
4. Access the Unified Push Server Console at http://localhost:8080/ag-push/. The default username and password are `admin` and `123`, respectively.

##Generate Alternative Unified Push Databases and Datasources
Information is provided here for generating Unified Push datasources for H2 from scratch and for several alternative database types. You can use any of the databases supported for use with JBoss EAP but the corresponding datasource added to the application server must have JNDI name `java:jboss/datasources/UnifiedPushDS`.

Note that if the JBoss EAP instance has not previously been used with the chosen database type, additional configuration must also be completed in order to enable the application server to connect to the database. As detailed here, sources and scripts are available to assist with all these processes in `jboss-unified-push-1.0.0.Beta1-server.zip` and `jboss-unified-push-1.0.0.Beta1-server-sources.zip`.

###H2 Database
You can create the Unified Push datasource for H2 from scratch and add it to JBoss EAP by completing the following steps:

1. Start JBoss EAP
```shell
$ ./path/to/jboss-eap/bin/standalone.sh
```
**Note:** Adding "-b 0.0.0.0" to the above commands will allow external clients (phones, tablets, desktops, etc...) to connect through your local network:
```shell
$ ./path/to/jboss-eap/bin/standalone.sh -b 0.0.0.0
```
2. Create and add the Unified Push datasource for the H2 database using the JBoss EAP CLI and provided configuration script
```shell
$ ./path/to/jboss-eap/bin/jboss-cli.sh --file=databases/h2-database-config.cli
```

###MySQL Database
You can use a [MySQL](http://www.mysql.com/) database with the Unified Push Server. As demonstrated here, JBoss EAP must first be configured for MySQL (steps 1 and 2) and the Unified Push MySQL database must exist (step 3) before JBoss EAP can be configured with the associated Unified Push datasource (steps 4 and 5).

To complete these prerequisite processes and configure JBoss EAP for the Unified Push MySQL database, complete the following steps:

1. Copy the MySQL module, located in the `databases/src/main/resources/modules/com` directory of `jboss-unified-push-1.0.0.Beta1-server-sources.zip`, to the JBoss EAP `modules` directory
```shell
$ cp -r /path/to/com /path/to/jboss-eap/modules/
```
2. Add the MySQL JDBC driver to the JBoss EAP `mysql` module
```shell
$ mvn dependency:copy -Dartifact=mysql:mysql-connector-java:5.1.18 \
-DoutputDirectory=/path/to/jboss-eap/modules/com/mysql/jdbc/main/
```
3. Create the Unified Push MySQL database
```shell
$ mysql -u <user-name>
mysql> create database unifiedpush default character set = "UTF8" default collate = "utf8_general_ci";
mysql> create user 'unifiedpush'@'localhost' identified by 'unifiedpush';
mysql> GRANT SELECT,INSERT,UPDATE,ALTER,DELETE,CREATE,DROP ON unifiedpush.* TO 'unifiedpush'@'localhost';h
```
4. Start JBoss EAP
```shell
$ ./path/to/jboss-eap/bin/standalone.sh
```
**Note:** Adding "-b 0.0.0.0" to the above commands will allow external clients (phones, tablets, desktops, etc...) to connect through your local network:
```shell
$ ./path/to/jboss-eap/bin/standalone.sh -b 0.0.0.0
```
5. Configure JBoss EAP to use the MySQL driver and create and add the Unified Push datasource for the MySQL database using the JBoss EAP CLI and provided configuration script
```shell
$ ./path/to/jboss-eap/bin/jboss-cli.sh --file=databases/mysql-database-config.cli
```

###PostgreSQL Database
You can use a [PostgreSQL](http://www.postgresql.org/) database with the Unified Push Server. As demonstrated here, JBoss EAP must first be configured for PostgreSQL (steps 1 and 2) and the Unified Push PostgreSQL database must exist (steps 3 and 4) before JBoss EAP can be configured with the associated Unified Push datasource (steps 5 and 6).

To complete these prerequisite processes and configure JBoss EAP for the Unified Push PostgreSQL database, complete the following steps:

1. Copy the PostgreSQL module, located in the `databases/src/main/resources/modules/org` directory of `jboss-unified-push-1.0.0.Beta1-server-sources.zip`, to the JBoss EAP `modules` directory
```shell
$ cp -r /path/to/org /path/to/jboss-eap/modules/
```
2. Add the PostgreSQL JDBC driver to the JBoss EAP `postgresql` module
```shell
$ mvn dependency:copy -Dartifact=org.postgresql:postgresql:9.2-1004-jdbc41 \
-DoutputDirectory=/Path/to/jboss-eap/modules/org/postgresql/main/
```
3. Create the Unified Push PostgreSQL database
```shell
$ psql -U <user-name>
psql> create database unifiedpush;
psql> create user unifiedpush with password 'unifiedpush';
psql> GRANT ALL PRIVILEGES ON DATABASE unifiedpush to unifiedpush;
```
4. If necessary, enable Unified Push Server access to the PostgreSQL database by adding the following lines to your `$POSTGRES_HOME/data/pg_hba.conf` file
```shell
host    all             unifiedpush     127.0.0.1/32            md5
```
5. Start JBoss EAP
```shell
$ ./path/to/jboss-eap/bin/standalone.sh
```
**Note:** Adding "-b 0.0.0.0" to the above commands will allow external clients (phones, tablets, desktops, etc...) to connect through your local network:
```shell
$ ./path/to/jboss-eap/bin/standalone.sh -b 0.0.0.0
```
6. Configure JBoss EAP to use the PostgreSQL driver and create and add the Unified Push datasource for the PostgreSQL database using the JBoss EAP CLI and provided configuration script
```shell
$ ./path/to/jboss-eap/bin/jboss-cli.sh --file=databases/postgresql-database-config.cli
```

##More Information
For more information about deploying, configuring and using the JBoss Unified Push Server, see the [JBoss Unified Push documentation](https://access.redhat.com/documentation/en-US/Red_Hat_JBoss_Unified_Push/).
