# https://groups.google.com/forum/#!topic/rubyonrails-security/IOO1vNZTzPA

Rack::Directory.prepend(Module.new do
  def list_directory(path_info, path, script_name)
    files = [['../','Parent Directory','','','']]

    url_head = (script_name.split('/') + path_info.split('/')).map do |part|
      Rack::Utils.escape_path part
    end

    Dir.entries(path).reject { |e| e.start_with?('.') }.sort.each do |node|
      stat = stat(node)
      next unless stat
      basename = ::File.basename(node)
      ext = ::File.extname(node)

      url = ::File.join(*url_head + [Rack::Utils.escape_path(basename)])
      size = stat.size
      type = stat.directory? ? 'directory' : Mime.mime_type(ext)
      size = stat.directory? ? '-' : filesize_format(size)
      mtime = stat.mtime.httpdate
      url << '/'  if stat.directory?
      basename << '/'  if stat.directory?

      files << [ url, basename, size, type, mtime ]
    end

    return [ 200, { CONTENT_TYPE =>'text/html; charset=utf-8'}, DirectoryBody.new(@root, path, files) ]
  end
end)
