SPEC_FILE = 'docs/active_docs/Service Management API.json'

def run_command cmd
  puts "--> executing: #{cmd}"
  puts "--> Remember to commit the resulting specs to the Porta repo."
  system cmd
end

def generate_docs
  cmd = 'bundle exec source2swagger -f lib/3scale/backend/listener.rb -c "##~" -o docs/active_docs/.'
  run_command cmd
  # source2swagger is really bad at generating readable JSON
  require 'json'
  File.write(SPEC_FILE, JSON.pretty_generate(JSON.parse(File.read(SPEC_FILE))) << "\n")
end

namespace :docs do
  namespace :swagger do
    # The swagger specs generated by these tasks need to be committed to the
    # Porta repo: https://github.com/3scale/porta/tree/master/doc/active_docs
    # (Service Management API.json)

    desc "Generates swagger docs"
    task :generate do
      generate_docs
    end
  end
end
