# How to Contribute

Please keep in mind that multiple types of contributions are possible, apart from contributing `code`:

  * Sharing feedback from using this project (e.g. in issues) 
  * Use cases, feature requests: Roadmap influence
  * Community Support, bug fixes, forum posts: Help to be helped
  * Documentation: Everyone needs good docs, Code is a moving target. If you find something wrong in the docs, fix it!!
  * Test cases (including Perf, load, security, unit tests, interop, ...) / CI

#### **Did you find a bug?**

* **If you find a security vulnerability**. Please [contact us privately](https://access.redhat.com/security/team/contact).

* **Ensure the bug was not already reported** by searching [here](https://issues.redhat.com/issues/?filter=12339079).

* If you're unable to find an issue addressing the problem, please [open a new one](https://issues.redhat.com/secure/CreateIssueDetails!init.jspa?pid=12318224&issuetype=3&components=12325241&priority=4), filling-in all the necessary information in the Issue template. This requires a jira login. If you don't have one already, you can create one.

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. Do include the relevant issue number in your commit message and the PR title. An example of the correct issue number format is "THREESCALE-1234"

#### **Do you intend to add a new feature or change an existing one?**

* Suggest your change by **[opening an issue first](https://issues.redhat.com/secure/CreateIssueDetails!init.jspa?pid=12318224&issuetype=3&components=12325241&priority=4)** with an explanation of the change, before writing any code.

* Please think twice about starting to work on code before having collected positive feedback about the proposed change. Maintainers may have already decided on a different improvement path, so your work may not be accepted.

* Include the relevant issue number in your commit messages and the PR title. An example of the correct issue number format is "THREESCALE-1234"

#### **Is there any other requirement to open a PR?**

We require all commits to be signed with GPG before merging the PR to master.
GPG is a form of encryption and it is used to verify the identity of the committer so other people can trust that the changes come from a trusted source.

To sign your commits, you only need to follow these steps:
  1. Check if you already have existing GPG keys in your local computer following [this guide](https://help.github.com/articles/checking-for-existing-gpg-keys/).
  2. If you don't have any, generate a new GPG key following [this guide](https://help.github.com/articles/generating-a-new-gpg-key/).
  3. Add the GPG key to your GitHub account following [this guide](https://help.github.com/articles/adding-a-new-gpg-key-to-your-github-account/).
  4. Tell Git about your signing key following [this guide](https://help.github.com/articles/telling-git-about-your-signing-key/).
  5. Sign your commits with the GPG key following [this guide](https://help.github.com/articles/signing-commits/).

#### **Do you have questions about the source code?**

* Ask any question by [raising an issue](https://issues.redhat.com/secure/CreateIssueDetails!init.jspa?pid=12318224&issuetype=3&components=12325241&priority=4). Maintainers could always use more help, so they'll be happy to assist you, no matter how silly you might think your question is. 

Thanks for reading this far!! 

With :heart:,
The 3scale team
