# frozen_string_literal: true

require 'test_helper'

class CVE20208165Test < ActiveSupport::TestCase
  # Can be removed after upgrade to Rails v5.2.4.3+
  test "MemCacheStore#read_entry does't use LocalCacheWithRaw" do
    local_cache = Rails.cache
    local_cache.expects(:fetch_entry).with('foo').returns(ActiveSupport::Cache::Entry.new('bar'))

    mem_cache = ActiveSupport::Cache::MemCacheStore.new('localhost')
    mem_cache.expects(:local_cache).returns(local_cache).at_least_once
    mem_cache.expects(:deserialize_entry).with('bar').never
    mem_cache.send(:read_entry, 'foo', raw: true)
  end
end
