# Contributing

If you want to contribute to the 3scale Toolbox project and make it better,
your help is very welcome.

## Open issues

Start by checking the list of issues in GitHub. Maybe your idea was discussed in the past or is part of an ongoing conversation.

In case it is a new idea for enhancement, a bug fix, a question or whatever unprecedented contribution you want to share, before sending a pull-request, please make sure to describe the issue so we can have a conversation together and help you fin dthe best way to get your contribution merged.

## How to make a clean pull request

* Create a personal [fork](https://docs.github.com/en/get-started/quickstart/fork-a-repo) of the project on Github.
* Clone the fork on your local machine. Your remote repo on Github is called `origin`.
* Create a new branch to work on! Branch from `main`.
* Implement/fix your feature, comment your code.
* Write or adapt tests as needed.
* [Run tests](/README.md#Testing) locally.
* Add or change the documentation as needed.
* [Sign](https://docs.github.com/en/github/authenticating-to-github/managing-commit-signature-verification/signing-commits) your commits (recommended but not required).
* Push your branch to your fork on Github, the remote `origin`.
* From your fork open a pull request in the correct branch. Target the project's `main` branch.
* If the maintainer requests further changes just push them to your branch. The PR will be updated automatically.

## Additional resources to contributors

* [Development](/README.md#Development)
* [Plugins](/README.md#Plugins)
