# Liquid Intro

This introduction is dealing with drops and variables available throughout
the 3scale system. If you are looking for an introduction to the Liquid template
language, please see the [Shopify documentation](http://wiki.shopify.com/Liquid).

## Global Variables

Each page or email template has its own set of top level variables
available for use. This set defines the information which you can
retrieve via liquids on each part of the developer portal. To check
which variables are available on the current page, add <code>{%
debug:help %}</code> drop in the page's code (or layout/partial). The
list of available variables will be printed as a comment in the HTML
(check the page's source). However there is a group of variables
shared on all the pages:



# Global variables

# Available Always

The following variables are
- urls
- provider
- today

## When logged in

- current_user
- current_account

[account-drop]: /p/admin/liquid_docs#account-drop "Account Drop"
[urls-drop]: /p/admin/liquid_docs#urls-drop "URLs Drop"



which are also the ones available to the user pages (i.e. the ones not generated by 3scale system). Mind, that the last two (current_*** ) are available only to the logged in users. In short:
* the 'urls' object stores absolute paths to built-in pages.
* 'provider' is the top level object containing all other objects.
* 'today' returns the current date.
* 'current_user' and 'current_account' refer to the currently logged-in user's object/account.

Another important thing to bear in mind is that in a great majority of
cases where this reference will use the 'account' drop, you will have
to change it for 'current_account' one to provide a proper context
(the system does not know to which account you are referring to).

Example:
URLS&current_user
One of the most common use cases include creating a custom user
widget. This can be easily done with the use of 'urls' object. An
exemplary code could look like this:

W<pre><code>&ltdiv class='user-widget'&gt

	{% if current_user %}
                <!-- if logged in -->
		&ltstrong&gt{{ current_user.username }}&lt/strong&gt
		&ltspan&gt|&lt/span&gt
		&lta href="/admin">Dashboard&lt/a&gt
		&ltspan&gt|&lt/span&gt
		&lta href="/logout"&gtLogout&lt/a&gt
	{% else %}
		&lta href="{{ urls.login }}"&gtLogin&lt/a&gt
		&ltspan&gt|&lt/span&gt
		&lta href="{{ urls.signup }}"&gtSignup&lt/a&gt
	{% endif %}
&lt/div&gt</code></pre>

Here inside the '.user-widget' div different content is generated
depending if the user is logged in or not. The conditional statement
<code>{% if current_user %}</code> is responsible for checking for
the existence of the 'current_user' variable, which is available only if
the user is logged into the portal. Inside the conditional, the
current user's username and links to his dashboard and session end are
generated. To check more methods for the 'current_user' variable
review its liquid drop [here](/p/admin/liquid_docs#currentuser-drop
"Current User Drop"). In case the user is not logged in links to the
login and signup page are displayed. The full 'urls' variable
reference can be found [here](/p/admin/liquid_docs#urls-drop "URLs
Drop").
