# frozen_string_literal: true

require 'test_helper'

class Master::Api::ServicesControllerTest < ActionController::TestCase
  def setup
    host! master_account.external_domain
  end

  test 'required master api_key' do
    delete :destroy, params: { api_key: 'invalid-api-key', id: 42, provider_id: 42 }

    assert_response 401
    assert_equal 'unauthorized', response.body
  end

  test 'destroy a service' do
    provider  = FactoryBot.create(:provider_account)
    buyer     = FactoryBot.create(:simple_buyer, provider_account: provider)
    service   = FactoryBot.create(:simple_service, account: provider)
    app_plan  =  FactoryBot.create(:simple_application_plan, issuer: service)
    cinstance = FactoryBot.create(:simple_cinstance, user_account: buyer, plan: app_plan)

    method_service_deleted_event_count = RailsEventStoreActiveRecord::Event.where(event_type: Services::ServiceDeletedEvent.to_s).method(:count)
    method_notification_event_count    = RailsEventStoreActiveRecord::Event.where(event_type: NotificationEvent.to_s).method(:count)
    assert_difference(method_notification_event_count, +1) do
      assert_difference(method_service_deleted_event_count, +1) do
        delete :destroy, params: { id: service.id, provider_id: provider.id, api_key: master_account.provider_key }
      end
    end

    assert_response 200
    assert_raise(ActiveRecord::RecordNotFound) { app_plan.reload }
    assert_raise(ActiveRecord::RecordNotFound) { service.reload }
    assert_raise(ActiveRecord::RecordNotFound) { cinstance.reload }
  end
end
