# Zync REST API example

This example project implements Zync's REST API protocol to synchronize OAuth2 clients.

## Prerequisites

Given 3scale API is configured to use:
  * OpenID Connect as the Authentication,
  * "REST API" as a OpenID Connect Issuer Type and
  * "http://id:secret@example.com/api" as OpenID Connect Issuer.

When a 3scale application is created/updated/deleted zync will try to replay that change to "http://example.com/api".

## Creating, updating and deleting Clients

Zync will make following requests to create/update/delete clients:

* `PUT /clients/:client_id` (create, update)
* `DELETE /clients/:client_id` (delete)

All endpoints must reply 2xx status code. Otherwise the request will be retried.

### Payload

The request payload in case of create and update is `application/json`:

```json
{
  "client_id": "ee305610",
  "client_secret": "ac0e42db426b4377096c6590e2b06aed",
  "client_name": "oidc-app",
  "redirect_uris": ["http://example.com"],
  "grant_types": ["client_credentials", "password"]
}
```

The request to delete a client has no payload.

## Using OAuth2 authentication

Zync will make GET request to `/.well-known/openid-configuration` endpoint and expect an `application/json` response.
The response payload should contain following: 

```json
{
  "token_endpoint": "http://idp.example.com/auth/realm/token"
}
```

Zync will use that `token_endpoint` URL to exchange the client_id and client_secret provided in the OpenID Connect Issuer URL 
for an access token using the OAuth2 protocol.

If the API responds with not successful response, Zync will fallback to HTTP Basic/Digest authentication using provided credentials.
 
## References

* OpenAPI Specification document [openapi.yml](openapi.yml)
* Sinatra application [app.rb](app.rb) 
