# frozen_string_literal: true

# [CVE-2020-8165] https://groups.google.com/g/rubyonrails-security/c/bv6fW4S0Y1c
# Can be removed after upgrade to Rails v5.2.4.3+

ActiveSupport::Cache::MemCacheStore.prepend(Module.new do
  protected

  # Reimplements from `ActiveSupport::Cache::Strategy::LocalCache#read_entry` instead of `ActiveSupport::Cache::MemCacheStore::LocalCacheWithRaw#read_entry`
  def read_entry(key, options)
    if cache = local_cache
      cache.fetch_entry(key) { super }
    else
      super
    end
  end

  # Redefines just like https://groups.google.com/group/rubyonrails-security/attach/1c0cea804792a/5-2-cache-storage.patch?part=0.1
  def deserialize_entry(entry)
    return unless entry
    entry.is_a?(Entry) ? entry : Entry.new(entry)
  end
end)
