var lineChartOptions = {
      chart: {
         renderTo: 'chart',
         defaultSeriesType: 'line',
         margin: [20,20,60,55]
      },
      credits: {enabled: false},
      
      title: {
        text: null
      },
      xAxis: {
      },
      yAxis: {
          title: {enabled: false},
          lineWidth: 1,
          min: 0,
          minPadding: 0,
          gridLineWidth: 1,
          tickWidth: 0,
          gridLineColor: '#e7e7e7',
          lineColor: '#e7e7e7',
          tickColor: '#e7e7e7',
          labels: {
            style: {
              fontSize: '8px',
            },                      
            enabled: true,
            formatter: function(){
              return Highcharts.numberFormat(this.value, 0);
            }        
          }
      },
      
      
      tooltip: {
        formatter: function() {
                  return '<b>'+ this.series.name +'</b><br/>'+
              this.x +': '+ this.y;
        },
        
      		backgroundColor: {
      			linearGradient: [0, 0, 0, 50],
      			stops: [
      				[0, 'rgba(66, 60, 50, .9)'],
      				[1, 'rgba(29, 27, 21, .8)']
      			]
      		},
      		borderWidth: 0,
      		style: {
      			color: '#FFF'
      		}
      	},
      plotOptions: {
          series: {
              fillColor: '#E6F2FA',
              lineWidth: 3,
              animation: false,
              shadow: false,
              marker: {
                lineWidth: 1,
                radius: 4
              }
          }
      },      
      legend: {
         layout: 'vertical',
         align: 'right',
         verticalAlign: 'top',
         x: -10,
         y: 100,
         borderWidth: 0
      },
      series: []
    };
   
