class GraphsController < FrontendController

  skip_before_action :set_x_frame_options_header

  layout 'graphs'

  def show
    @service = current_account.accessible_services.find(params[:service_id])
    @now = Time.now.to_date
    @since = params[:since].presence || (1.month.ago).to_date
    @until = params[:until].presence || @now
  end

end
