# here we define abilities for admins of master account
Ability.define do |user|
  if user && user.admin? && user.account.master?
    can :manage, :logo
    can [ :read, :update, :delete, :configure ], Account

    can :impersonate, Account do | account |
      account.has_3scaleadmin?
    end

    can :suspend, Account do | account |
      account.can_suspend?
    end

    can :resume, Account do | account |
      account.can_resume?
    end

    can :manage, user.account

    can :manage, :provider_plans
    can :manage, :partners
    can :manage, :applications
    can :manage, :charging
    can :manage, :finance
    can :manage, :monitoring
    can :manage, :analytics
    can :manage, :plans
    can :manage, :forum
    can :manage, :portal
    can :manage, :settings
    can :manage, :service_contracts
    can :admin, :log_requests
    can :manage, :groups
    can :manage, :authentication_providers
    can :manage, :web_hooks

    #COPY these come from forum.rb
    can :manage, TopicCategory do |category|
      category.forum.account = user.account
    end

    can :update, Service, :account_id => user.account_id
    can :create, Service
    can :manage, :multiple_users
    can :manage, User
    can :manage, Invitation
    can :manage, Invoice, provider_account_id: user.account_id

    can :custom_key, Cinstance do |cinstance|
      cinstance.provider_account == user.account
    end

    user.account.settings.switches.each do |name, _switch|
      can :admin, name
    end
  end
end
