Ability.define do |user|
  if user && (account = user.account)

    settings = if account.buyer?
      account.provider_account.settings
               else
      account.settings
               end

    # :see means buyer can use it (see buyer_any.rb)
    # :admin means provider can see the upgrade notices (see provider_admin.rb)
    # :manage means provider can show and hide it
    settings.switches.each do |name, switch|
      if can?(:admin, name) && switch.allowed?
        can :manage, name
      end
    end
  end
end
