Sidekiq::Client.try(:reliable_push!) unless Rails.env.test?

Sidekiq.configure_server do |config|
  config.try(:reliable!)

  config.redis = System::Application.config.sidekiq
  config.error_handlers << System::ErrorReporting.method(:report_error)

  config.server_middleware do |chain|
    chain.add ThreeScale::Analytics::SidekiqMiddleware
  end

  faraday = ThreeScale::Core.faraday
  faraday.options.timeout = 30
  faraday.options.open_timeout = 10
end

Sidekiq.configure_client do |config|
  config.redis = System::Application.config.sidekiq

  config.client_middleware do |chain|
    chain.add ThreeScale::SidekiqLoggingMiddleware
  end
end
