module ApiDocs
  class AccountData

    def initialize(account)
      @account = account
    end

    def as_json(options = {})
      @account.nil? ? return_error : return_account_data
    end

    def account_data
      Hash[data_items.map{ |item| [item.to_sym, send(item)] }]
    end

    private

    def return_account_data
      { :status => 200,
        :results => account_data
      }
    end

    def user_keys
      apps.map do |app|
        { :name  => app.name,
          :value => app.user_key }
      end
    end

    def app_keys
      apps.map do |app|
        { :name  => app.name,
          :value => app.keys.first || ""}
      end
    end

    def app_ids
      apps.map do |app|
        { :name  => app.name,
          :value => app.application_id }
      end
    end

    def return_error
      {:status => 401}
    end

  end
end
