class DeveloperPortal::Admin::Applications::LogRequestsController <  ::DeveloperPortal::BaseController

  before_filter :find_application
  before_filter :authorize_log_requests

  activate_menu :dashboard

  liquify prefix: 'applications/log_requests'

  def index
    @log_requests = @cinstance.backend_object.log_requests
  end

  def purge
    @cinstance.backend_object.delete_all_log_requests

    respond_to do |format|
      format.html do
        flash[:notice] = 'All requests logs were purged.'
        redirect_to(admin_application_log_requests_path(@cinstance))
      end

      format.js
    end

  end

  protected

  def authorize_log_requests
    return render_error :not_found, :status => :not_found unless @cinstance.service.buyer_can_see_log_requests?
    authorize! :see, :log_requests
  end

  def find_application
    @cinstance = current_account.bought_cinstances.find(params[:application_id])
  end

end
