module Logic::Backend

  class Version
    def initialize(version)
      @version = version.to_s
    end

    def user_key?
      @version == '1'
    end

    def app_id?
      @version == '2'
    end

    def oauth?
      @version == 'oauth'
    end

    def ==(other)
      super or @version == other
    end
  end

  # TODO: change it into cancan rule
  module Service

    VERSIONS = {
      I18n.t("api_key", scope: :authentication_options) => "1",
      I18n.t("key_pair", scope: :authentication_options) => "2",
      I18n.t("oauth", scope: :authentication_options)=> "oauth"
    }

    def app_keys_allowed?
      self.backend_version >= "2"
    end
  end
end
