(function() {
  var CreateApplication;

  CreateApplication = (function() {
    function CreateApplication() {
      this.check_selected_plan();
      this.previews_service;
    }

    CreateApplication.prototype.metadata = function() {
      return $('#metadata-form');
    };

    CreateApplication.prototype.service_plans_names = function() {
      return this.metadata().data('service_plans_names');
    };

    CreateApplication.prototype.services_contracted = function() {
      return this.metadata().data('services_contracted');
    };

    CreateApplication.prototype.relation_service_and_service_plans = function() {
      return this.metadata().data('relation_service_and_service_plans');
    };

    CreateApplication.prototype.relation_plans_services = function() {
      return this.metadata().data('relation_plans_services');
    };

    CreateApplication.prototype.service_plan_contracted_for_service = function() {
      return this.metadata().data('service_plan_contracted_for_service');
    };

    CreateApplication.prototype.selected_plan = function() {
      return $("#cinstance_plan_id").val();
    };

    CreateApplication.prototype.service_of_selected_plan = function() {
      return this.relation_plans_services()[this.selected_plan()];
    };

    CreateApplication.prototype.check_selected_plan = function() {
      var service, service_plan_contracted, service_plans;
      service = this.service_of_selected_plan();
      service_plans = this.relation_service_and_service_plans()[service];
      if (this.previews_service !== service) {
        this.disable_form(false);
        this.previews_service = service;
        if ($.inArray(service, this.services_contracted()) !== -1) {
          service_plan_contracted = this.service_plan_contracted_for_service()[service];
          $("#cinstance_service_plan_id").html("<option value='" + service_plan_contracted.id + "'> " + service_plan_contracted.name + " </option>");
          return $("#cinstance_service_plan_id").attr('disabled', 'disabled');
        } else if (service_plans.length !== 0) {
          return this.update_combo(service_plans);
        } else {
          $("#cinstance_service_plan_id").html("<option> No service plan for the application plan </option>");
          return this.disable_form(true);
        }
      }
    };

    CreateApplication.prototype.disable_form = function(disable) {
      $('#link-help-new-application-service').toggle(disable);
      this.disable_field('#submit-new-app', disable);
      return this.disable_field('#cinstance_service_plan_id', disable);
    };

    CreateApplication.prototype.disable_field = function(field, disable) {
      if (disable) {
        return $(field).attr('disabled', 'disabled');
      } else {
        return $(field).removeAttr('disabled');
      }
    };

    CreateApplication.prototype.update_combo = function(service_plans) {
      var options;
      options = "";
      $(service_plans).each(function(index, service_plan) {
        var selected_attr;
        selected_attr = service_plan["default"] ? 'selected="selected"' : '';
        return options += "<option value='" + service_plan.id + "' " + selected_attr + ">" + service_plan.name + "</option>";
      });
      $("#cinstance_service_plan_id").html(options);
      return $("#cinstance_service_plan_id").removeAttr('disabled');
    };

    return CreateApplication;

  })();

  $(document).ready(function() {
    var create_application;
    create_application = new CreateApplication();
    return $("#cinstance_plan_id").on("change", function() {
      return create_application.check_selected_plan();
    });
  });

}).call(this);
