import $ from 'jquery'

import {StatsLogsSource} from 'stats/lib/logs_source'

describe('StatsLogsSource', () => {
  let logs = new StatsLogsSource(42)

  it('should send the right params when making ajax request', (done) => {
    let state = {
      dateRange: {since: '2015-08-08', until: '2015-09-09'},
      pagination: {page: 1, total: 50, per_page: 5},
      code: '4XX, 5XX'
    }
    spyOn($, 'getJSON').and.callFake(() => {
      return new $.Deferred()
    })

    logs.logRequests(state)

    expect($.getJSON).toHaveBeenCalledWith('/services/42/log_requests.json', {
      search: {
        timestamp: {
          '$gt': '2015-08-08',
          '$lt': '2015-09-09'
        },
        code: '4XX, 5XX'
      },
      page: 1
    })
    done()
  })
})
