require 'test_helper'

class Api::ApplicationPlansControllerTest < ActionController::TestCase

  def setup
    @provider = FactoryGirl.create(:provider_account)
    @service  = FactoryGirl.create(:service, account: @provider)
    @plan     = FactoryGirl.create(:application_plan, service: @service)

    host! @provider.admin_domain

    login_provider @provider
  end

  def test_destroy
    delete :destroy, id: @plan.id

    assert_response :redirect
    assert_nil flash[:error]
  end

  def test_plan_cannot_be_deleted
    @plan.create_contract_with(FactoryGirl.create(:buyer_account))

    delete :destroy, id: @plan.id

    assert_response :redirect
    assert_equal error_message(:has_contracts), flash[:error]
  end

  def test_plan_cannot_be_deleted_because_of_customizations
    customization = FactoryGirl.create(:application_plan, original_id: @plan.id)
    customization.create_contract_with(FactoryGirl.create(:buyer_account))

    delete :destroy, id: @plan.id

    assert_response :redirect
    assert_equal error_message(:customizations_has_contracts), flash[:error]
  end

  private

  def error_message(key)
    I18n.t("activerecord.errors.models.application_plan.#{key}")
  end
end
