require 'test_helper'

class ApplicationControllerTest < ActionController::TestCase

  test '#save_return_to' do
    ac = ApplicationController.new
    assert_equal '/foo', ac.send(:safe_return_to, '/foo')
    assert_equal '/foo?bar=42', ac.send(:safe_return_to, '/foo?bar=42')
    assert_equal '/', ac.send(:safe_return_to, 'http://example.com/')
    assert_equal '/?foo=bar', ac.send(:safe_return_to, 'http://example.com/?foo=bar')
    assert_equal '/?foo=bar&foo2=bar2', ac.send(:safe_return_to, 'http://example.com/?foo=bar&foo2=bar2')
  end
end
