require 'test_helper'

class Buyers::InvoicesControllerTest < ActionController::TestCase

  def setup
    @cinstance = Factory(:cinstance)
    @buyer = @cinstance.buyer_account
    @provider_account = @cinstance.provider_account
    @provider_account.create_billing_strategy
    @provider_account.settings.allow_finance!
    @request.host = @provider_account.admin_domain

    @provider_account.settings.allow_finance
    login_as(@provider_account.users.first)
  end

  test 'list all invoices for a buyer' do
    get :index, :account_id => @buyer.to_param
    assert_response :success
    assert_template 'buyers/invoices/index'
    assert_not_nil assigns(:invoices)
    assert_active_menu(:buyers)
  end

  test 'create a new invoice for a buyer' do
    post :create, :account_id => @buyer.to_param
    assert_response :redirect
    assert_equal @invoice, assigns(:invoice)
    assert_active_menu(:buyers)
  end

  test 'edit existing invoice header' do
    @invoice = Factory.create(:invoice,
                                :buyer_account => @buyer,
                                :provider_account => @provider_account)
    Invoice.any_instance.stubs(:find).returns(@invoice)

    get :edit, :id => @invoice.to_param, :account_id => @buyer.to_param
    assert_response :success
    assert_template 'buyers/invoices/edit'
    assert_equal @invoice, assigns(:invoice)
    assert_active_menu(:buyers)
  end
end