require 'test_helper'

class Provider::Admin::Account::PaymentGateways::BraintreeBlueControllerTest < ActionController::TestCase

  def setup
    @provider = Factory(:provider_account, credit_card_auth_code: 'foo')
    host! @provider.admin_domain
    login_provider @provider
    Rails.application.config.three_scale.stubs(finance_enabled: true)
  end

  test 'delete destroy' do
    assert  @provider.credit_card_stored?
    ActiveMerchant::Billing::BogusGateway.any_instance.expects(:unstore)
    delete :destroy
    assert_response :redirect
    @provider.reload
    refute @provider.credit_card_stored?
  end

  test 'when finance is disabled' do
    Rails.application.config.three_scale.stubs(finance_enabled: false)

    get :show
    assert_response :forbidden

    get :edit
    assert_response :forbidden

    get :hosted_success
    assert_response :forbidden

    put :update
    assert_response :forbidden

    delete :destroy
    assert_response :forbidden

  end
end
