require 'test_helper'

class ValidateEmailInterceptorTest < ActionMailer::TestCase

  class DoubleMailer < ActionMailer::Base
    def new_account(to: nil, bcc: nil)
      mail(subject: 'New account', to: to, bcc: bcc, from: 'alex@alaska.com') do |format|
        format.text { render text: 'New account' }
      end
    end
  end

  def test_validate_to_attribute
    assert_difference(ActionMailer::Base.deliveries.method(:count), +1) do
      DoubleMailer.new_account(to: 'alaska@wild.com').deliver
    end

    assert_difference(ActionMailer::Base.deliveries.method(:count), +1) do
      DoubleMailer.new_account(bcc: ['alaska@wild.com']).deliver
    end

    assert_no_difference(ActionMailer::Base.deliveries.method(:count)) do
      DoubleMailer.new_account(to: nil, bcc: nil).deliver
    end
  end
end
