require 'test_helper'

module PaymentGateways
  class MerchantESolutionsCryptTest < ActiveSupport::TestCase
    def setup
      @user = mock
      @user.stubs(id: 'user-id')
      @account = mock
      attributes = {
        payment_gateway_type: :merchant_e_solutions,
        payment_gateway_options: {
          merchantAccount: '12345',
          login: 'hello',
          password: 'world'
        }
      }
      @provider_account = FactoryGirl.build_stubbed(:simple_provider, attributes)
      @payment_gateway = @provider_account.payment_gateway

      @account.stubs(provider_account: @provider_account, id: 'account-id')
      @user.stubs(account: @account, email: 'email@example.com')
    end

    test '#buyer_reference' do
      merchant_e_solutions = build_merchant_e_solution
      assert_equal "3scale-#{@provider_account.id}-#{@account.id}-#{@user.id}", merchant_e_solutions.buyer_reference
    end

    test '#test? uses Active Merchant gateway_mode :production value' do
      ActiveMerchant::Billing::Base.stubs(:gateway_mode).returns(:production)
      @merchant_e_solutions = build_merchant_e_solution
      refute @merchant_e_solutions.test?
    end

    test '#endpoint_url points to production url' do
      ActiveMerchant::Billing::Base.stubs(:gateway_mode).returns(:production)
      @merchant_e_solutions = build_merchant_e_solution
      assert_equal 'https://www.merchante-solutions.com/jsp/tpg/secure_checkout.jsp', @merchant_e_solutions.endpoint_url
    end

    test '#endpoint_url points to test url' do
      ActiveMerchant::Billing::Base.stubs(:gateway_mode).returns(:test)
      @merchant_e_solutions = build_merchant_e_solution
      assert_equal 'https://test.merchante-solutions.com/jsp/tpg/secure_checkout.jsp', @merchant_e_solutions.endpoint_url
    end

    test '#test? uses Active Merchant gateway_mode :test value' do
      ActiveMerchant::Billing::Base.stubs(:gateway_mode).returns(:test)
      @merchant_e_solutions = build_merchant_e_solution
      assert @merchant_e_solutions.test?
    end

    protected

    def build_merchant_e_solution
      PaymentGateways::MerchantESolutionsCrypt.new(@user)
    end

  end
end
